"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.productCatalogService = exports.ProductCatalogService = void 0;
const product_repo_1 = require("../database/repositories/product.repo");
class ProductCatalogService {
    productRepo;
    constructor(productRepo) {
        this.productRepo = productRepo || new product_repo_1.ProductRepository();
    }
    async getProviderCostsAndGuardrails(params) {
        if (!params.canonicalCode)
            return {};
        const product = await this.productRepo.findByCanonicalCode(params.canonicalCode);
        if (!product)
            return {};
        const providerCosts = {};
        for (const p of product.providers) {
            if (p.status === 'inactive' || p.status === 'maintenance')
                continue;
            providerCosts[String(p.providerId)] = p.costPrice;
            if (p.providerName)
                providerCosts[p.providerName] = p.costPrice;
        }
        return { maxAllowedCost: product.maxAllowedCost, providerCosts };
    }
}
exports.ProductCatalogService = ProductCatalogService;
exports.productCatalogService = new ProductCatalogService();
