import { ServicePlanRepository } from '../database/repositories/service-plan.repo';
import { ServiceProviderRepository } from '../database/repositories/service-provider.repo';
import { ASBDataProvider } from '../integrations/vtu-bills/asbdata.provider';
export declare class PlanSyncService {
    private servicePlanRepo;
    private serviceProviderRepo;
    private asbDataProvider;
    constructor(servicePlanRepo: ServicePlanRepository, serviceProviderRepo: ServiceProviderRepository, asbDataProvider: ASBDataProvider);
    syncPlansFromASBData(): Promise<{
        synced: number;
        updated: number;
        errors: string[];
    }>;
    private formatPlanName;
    private categorizePlan;
    private calculateSellingPrice;
    getPlansFromDatabase(network: string, planType?: string): Promise<any[]>;
    getPlanTypesFromDatabase(): Promise<Array<{
        value: string;
        label: string;
    }>>;
}
