import { ServiceConfigurationDocument } from '../database/models/service-configuration';
export declare class ConfigurationService {
    private static instance;
    private cache;
    private readonly CACHE_TTL;
    private constructor();
    static getInstance(): ConfigurationService;
    getConfigValue(key: string, scope?: 'global' | 'service' | 'provider' | 'plan', opts?: {
        serviceType?: string;
        providerId?: string;
        planId?: string;
    }): Promise<any>;
    getConfigValues(keys: string[], scope?: 'global' | 'service' | 'provider' | 'plan', opts?: {
        serviceType?: string;
        providerId?: string;
        planId?: string;
    }): Promise<Record<string, any>>;
    getConfigsByCategory(category: string): Promise<Record<string, any>>;
    setConfigValue(key: string, value: any, scope?: 'global' | 'service' | 'provider' | 'plan', opts?: {
        serviceType?: string;
        providerId?: string;
        planId?: string;
        name?: string;
        description?: string;
        category?: string;
        type?: 'string' | 'number' | 'boolean' | 'object' | 'array';
    }): Promise<ServiceConfigurationDocument>;
    clearCache(key?: string, scope?: string, opts?: any): void;
    private buildCacheKey;
    getServiceConfigs(serviceType: string): Promise<Record<string, any>>;
    hasConfig(key: string, scope?: 'global' | 'service' | 'provider' | 'plan', opts?: {
        serviceType?: string;
        providerId?: string;
        planId?: string;
    }): Promise<boolean>;
}
export declare const configurationService: ConfigurationService;
