"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const errors_1 = require("../core/errors");
const payment_service_1 = require("../modules/payments/payment.service");
const auth_1 = require("../core/middleware/auth");
const router = (0, express_1.Router)();
router.post('/paystack/initialize', (0, errors_1.asyncHandler)(async (_req, res) => {
    const chargeResponse = await payment_service_1.paymentService.initializeCharge({
        amount: 1000,
        email: 'test@example.com',
        provider: 'paystack',
        reference: `PSK-${Date.now()}`,
        callbackUrl: 'https://app.example.com/callback',
        currency: 'NGN',
        customerName: 'Test Customer',
        customerPhone: '+2348012345678',
        metadata: {
            orderId: 'ORD-123',
            productType: 'subscription',
            testMode: true,
        },
    });
    res.status(200).json({
        success: true,
        message: 'Paystack payment initialized',
        data: chargeResponse,
    });
}));
router.post('/flutterwave/initialize', (0, errors_1.asyncHandler)(async (_req, res) => {
    const chargeResponse = await payment_service_1.paymentService.initializeCharge({
        amount: 1500,
        email: 'test@example.com',
        provider: 'flutterwave',
        reference: `FLW-${Date.now()}`,
        callbackUrl: 'https://app.example.com/callback',
        currency: 'NGN',
        customerName: 'Test Customer',
        customerPhone: '+2348012345678',
        metadata: {
            orderId: 'ORD-124',
            productType: 'one-time',
            testMode: true,
        },
    });
    res.status(200).json({
        success: true,
        message: 'Flutterwave payment initialized',
        data: chargeResponse,
    });
}));
router.get('/verify/:provider/:reference', (0, errors_1.asyncHandler)(async (req, res) => {
    const { provider, reference } = req.params;
    const verificationResponse = await payment_service_1.paymentService.verifyPayment({
        reference: reference || '',
        provider: provider,
    });
    res.status(200).json({
        success: true,
        message: 'Payment verification completed',
        data: verificationResponse,
    });
}));
router.post('/refund/:provider/:reference', auth_1.requireAuth, (0, errors_1.asyncHandler)(async (req, res) => {
    const { provider, reference } = req.params;
    const { amount, reason } = req.body;
    const refundResult = await payment_service_1.paymentService.processRefund({
        reference: reference || '',
        provider: provider,
        amount: amount ? Number(amount) : 0,
        reason: reason || 'Customer request',
    });
    res.status(200).json({
        success: true,
        message: 'Refund processed successfully',
        data: refundResult,
    });
}));
router.get('/reconcile/:provider', auth_1.requireAuth, (0, errors_1.asyncHandler)(async (req, res) => {
    const { provider } = req.params;
    const { startDate, endDate } = req.query;
    const reconciliationResult = await payment_service_1.paymentService.reconcileTransactions({
        provider: provider,
        startDate: startDate || '2024-01-01',
        endDate: endDate || '2024-12-31',
    });
    res.status(200).json({
        success: true,
        message: 'Transaction reconciliation completed',
        data: reconciliationResult,
    });
}));
router.get('/stats', auth_1.requireAuth, (0, errors_1.asyncHandler)(async (req, res) => {
    const { provider, startDate, endDate } = req.query;
    const stats = await payment_service_1.paymentService.getPaymentStats(provider, startDate, endDate);
    res.status(200).json({
        success: true,
        message: 'Payment statistics retrieved',
        data: stats,
    });
}));
router.post('/test-webhook/:provider', (0, errors_1.asyncHandler)(async (req, res) => {
    const { provider } = req.params;
    const { reference } = req.body;
    if (provider === 'paystack') {
        const testEvent = {
            event: 'charge.success',
            data: {
                id: 123456789,
                domain: 'test',
                amount: 100000,
                currency: 'NGN',
                source: 'api',
                reason: 'Test payment',
                recipient: 0,
                status: 'success',
                transfer_code: 'TRF-TEST-123',
                created_at: new Date().toISOString(),
                updated_at: new Date().toISOString(),
                metadata: {
                    custom_fields: [],
                    referrer: 'test',
                },
                reference: reference || 'TEST-REF-123',
                fees: 0,
                customer: {
                    id: 1,
                    first_name: 'Test',
                    last_name: 'Customer',
                    email: 'test@example.com',
                    customer_code: 'CUS_TEST',
                    phone: '+2348012345678',
                    metadata: null,
                    risk_action: 'default',
                    international_format_phone: '+2348012345678',
                },
            },
        };
        const result = await payment_service_1.paymentService.processWebhook({
            provider: 'paystack',
            signature: 'test-signature',
            rawBody: JSON.stringify(testEvent),
            event: testEvent,
        });
        res.status(200).json({
            success: true,
            message: 'Test webhook processed',
            data: result,
        });
    }
    else if (provider === 'flutterwave') {
        const testEvent = {
            event: 'charge.completed',
            data: {
                id: 123456789,
                tx_ref: reference || 'TEST-TX-REF-123',
                flw_ref: 'FLW-TEST-123',
                device_fingerprint: 'test-fingerprint',
                amount: 1000,
                currency: 'NGN',
                charged_amount: 1000,
                app_fee: 10,
                merchant_fee: 0,
                processor_response: 'Approved',
                auth_model: 'PIN',
                ip: '127.0.0.1',
                narration: 'Test transaction',
                status: 'successful',
                payment_type: 'card',
                created_at: new Date().toISOString(),
                updated_at: new Date().toISOString(),
                account_id: 1,
                customer: {
                    id: 1,
                    phone_number: '+2348012345678',
                    name: 'Test Customer',
                    email: 'test@example.com',
                    created_at: new Date().toISOString(),
                },
                meta: {},
            },
        };
        const result = await payment_service_1.paymentService.processWebhook({
            provider: 'flutterwave',
            signature: 'test-signature',
            rawBody: JSON.stringify(testEvent),
            event: testEvent,
        });
        res.status(200).json({
            success: true,
            message: 'Test webhook processed',
            data: result,
        });
    }
    else {
        res.status(400).json({
            success: false,
            message: 'Invalid provider. Use paystack or flutterwave',
        });
    }
}));
router.get('/providers', (0, errors_1.asyncHandler)(async (_req, res) => {
    const providers = [
        {
            id: 'paystack',
            name: 'Paystack',
            description: 'Paystack payment gateway',
            supportedCurrencies: ['NGN', 'USD'],
            supportedPaymentTypes: ['card', 'bank_transfer', 'ussd', 'qr'],
            logo: 'https://paystack.com/static/img/logo-blue.svg',
            features: [
                'Webhook support',
                'Transaction verification',
                'Refund processing',
                'Reconciliation',
            ],
        },
        {
            id: 'flutterwave',
            name: 'Flutterwave',
            description: 'Flutterwave payment gateway',
            supportedCurrencies: ['NGN', 'USD', 'EUR', 'GBP'],
            supportedPaymentTypes: ['card', 'bank_transfer', 'ussd', 'qr', 'mobile_money'],
            logo: 'https://flutterwave.com/images/logo.svg',
            features: [
                'Webhook support',
                'Transaction verification',
                'Refund processing',
                'Reconciliation',
                'Bank account validation',
            ],
        },
    ];
    res.status(200).json({
        success: true,
        message: 'Payment providers retrieved successfully',
        data: providers,
    });
}));
router.post('/validate-bank', (0, errors_1.asyncHandler)(async (req, res) => {
    const { accountNumber, accountBank } = req.body;
    if (!accountNumber || !accountBank) {
        res.status(400).json({
            success: false,
            message: 'Account number and bank are required',
        });
        return;
    }
    const { flutterwaveAdapter } = await Promise.resolve().then(() => __importStar(require('../integrations/flutterwave')));
    const validationResult = await flutterwaveAdapter.validateBankAccount(accountNumber, accountBank);
    res.status(200).json({
        success: true,
        message: 'Bank account validation completed',
        data: validationResult,
    });
}));
router.get('/webhook-status/:reference', (0, errors_1.asyncHandler)(async (req, res) => {
    const { reference } = req.params;
    const { redisManager } = await Promise.resolve().then(() => __importStar(require('../config/redis')));
    const paymentIntent = await redisManager.get(`payment_intent:${reference}`);
    res.status(200).json({
        success: true,
        message: 'Webhook status retrieved successfully',
        data: {
            reference,
            hasPaymentIntent: !!paymentIntent,
            paymentIntent: paymentIntent ? JSON.parse(paymentIntent) : null,
            timestamp: new Date().toISOString(),
        },
    });
}));
exports.default = router;
