"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_routes_1 = __importDefault(require("../modules/auth/auth.routes"));
const user_routes_1 = __importDefault(require("../modules/users/user.routes"));
const session_routes_1 = __importDefault(require("../modules/users/session.routes"));
const wallet_routes_1 = __importDefault(require("../modules/wallet/wallet.routes"));
const bills_routes_1 = __importDefault(require("../modules/bills/bills.routes"));
const vtu_routes_1 = __importDefault(require("../modules/vtu/vtu.routes"));
const payment_routes_1 = __importDefault(require("../modules/payments/payment.routes"));
const vtu_bills_routes_1 = __importDefault(require("../modules/vtu-bills/vtu-bills.routes"));
const verification_routes_1 = __importDefault(require("../modules/verification/verification.routes"));
const jamb_routes_1 = __importDefault(require("../modules/jamb/jamb.routes"));
const transaction_routes_1 = __importDefault(require("../modules/transactions/transaction.routes"));
const dispute_routes_1 = __importDefault(require("../modules/disputes/dispute.routes"));
const queue_routes_1 = __importDefault(require("../modules/queue/queue.routes"));
const index_1 = __importDefault(require("../webhooks/index"));
const admin_routes_1 = __importDefault(require("./admin.routes"));
const admin_services_routes_1 = __importDefault(require("./admin-services.routes"));
const admin_docs_routes_1 = __importDefault(require("./admin-docs.routes"));
const cache_examples_1 = __importDefault(require("./cache-examples"));
const security_examples_1 = __importDefault(require("./security-examples"));
const payment_examples_1 = __importDefault(require("./payment-examples"));
const verification_examples_1 = __importDefault(require("./verification-examples"));
const analytics_routes_1 = __importDefault(require("./analytics.routes"));
const router = (0, express_1.Router)();
router.get('/', (_req, res) => {
    res.status(200).json({ message: 'Unify API is running', version: '1.0.0' });
});
router.use('/v1/auth', auth_routes_1.default);
router.use('/v1/users', user_routes_1.default);
router.use('/v1/sessions', session_routes_1.default);
router.use('/v1/wallet', wallet_routes_1.default);
router.use('/v1/bills', bills_routes_1.default);
router.use('/v1/vtu', vtu_routes_1.default);
router.use('/v1/payments', payment_routes_1.default);
router.use('/v1/vtu-bills', vtu_bills_routes_1.default);
router.use('/v1/verification', verification_routes_1.default);
router.use('/v1/jamb', jamb_routes_1.default);
router.use('/v1/transactions', transaction_routes_1.default);
router.use('/v1/disputes', dispute_routes_1.default);
router.use('/v1/queue', queue_routes_1.default);
router.use('/v1/webhooks', index_1.default);
router.use('/v1/admin', admin_routes_1.default);
router.use('/v1/admin/services', admin_services_routes_1.default);
router.use('/v1/admin/docs', admin_docs_routes_1.default);
router.use('/v1/analytics', analytics_routes_1.default);
if (process.env['NODE_ENV'] === 'development') {
    router.use('/v1/examples', cache_examples_1.default);
    router.use('/v1/security', security_examples_1.default);
    router.use('/v1/payment-examples', payment_examples_1.default);
    router.use('/v1/verification-examples', verification_examples_1.default);
}
exports.default = router;
