"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../core/middleware/auth");
const errors_1 = require("../core/errors");
const router = (0, express_1.Router)();
router.use(auth_1.requireAuth);
router.use((0, auth_1.requireRole)('admin'));
router.get('/dashboard', (0, errors_1.asyncHandler)(async (req, res) => {
    try {
        const { User } = await Promise.resolve().then(() => __importStar(require('../modules/users/user.model')));
        const { Transaction } = await Promise.resolve().then(() => __importStar(require('../database/models/transactions')));
        const { Dispute } = await Promise.resolve().then(() => __importStar(require('../database/models/dispute')));
        const { Wallet } = await Promise.resolve().then(() => __importStar(require('../database/models/wallet')));
        const now = new Date();
        const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
        const yesterday = new Date(today);
        yesterday.setDate(yesterday.getDate() - 1);
        const lastWeek = new Date(today);
        lastWeek.setDate(lastWeek.getDate() - 7);
        const lastMonth = new Date(today);
        lastMonth.setMonth(lastMonth.getMonth() - 1);
        const totalUsers = await User.countDocuments({ isDeleted: { $ne: true } });
        const activeUsers = await User.countDocuments({
            isDeleted: { $ne: true },
            lastLoginAt: { $gte: lastWeek }
        });
        const newUsersToday = await User.countDocuments({
            createdAt: { $gte: today },
            isDeleted: { $ne: true }
        });
        const newUsersThisMonth = await User.countDocuments({
            createdAt: { $gte: lastMonth },
            isDeleted: { $ne: true }
        });
        const totalTransactions = await Transaction.countDocuments();
        const successfulTransactions = await Transaction.countDocuments({ status: 'successful' });
        const pendingTransactions = await Transaction.countDocuments({ status: 'pending' });
        const failedTransactions = await Transaction.countDocuments({ status: 'failed' });
        const todayTransactions = await Transaction.aggregate([
            { $match: { createdAt: { $gte: today }, status: 'successful' } },
            { $group: { _id: null, total: { $sum: '$amount' }, count: { $sum: 1 } } }
        ]);
        const yesterdayTransactions = await Transaction.aggregate([
            { $match: { createdAt: { $gte: yesterday, $lt: today }, status: 'successful' } },
            { $group: { _id: null, total: { $sum: '$amount' }, count: { $sum: 1 } } }
        ]);
        const thisMonthTransactions = await Transaction.aggregate([
            { $match: { createdAt: { $gte: lastMonth }, status: 'successful' } },
            { $group: { _id: null, total: { $sum: '$amount' }, count: { $sum: 1 } } }
        ]);
        const totalDisputes = await Dispute.countDocuments();
        const openDisputes = await Dispute.countDocuments({ status: 'opened' });
        const resolvedDisputes = await Dispute.countDocuments({ status: 'resolved' });
        const totalWallets = await Wallet.countDocuments();
        const totalBalance = await Wallet.aggregate([
            { $group: { _id: null, total: { $sum: '$availableBalance' } } }
        ]);
        const userGrowthToday = newUsersToday;
        const userGrowthThisMonth = newUsersThisMonth;
        const transactionGrowthToday = todayTransactions[0]?.count || 0;
        const transactionGrowthYesterday = yesterdayTransactions[0]?.count || 0;
        const transactionGrowthPercentage = transactionGrowthYesterday > 0
            ? ((transactionGrowthToday - transactionGrowthYesterday) / transactionGrowthYesterday * 100)
            : 0;
        const dashboardData = {
            overview: {
                totalUsers,
                activeUsers,
                totalTransactions,
                totalDisputes,
                totalWallets,
                totalBalance: totalBalance[0]?.total || 0
            },
            userStats: {
                total: totalUsers,
                active: activeUsers,
                newToday: newUsersToday,
                newThisMonth: newUsersThisMonth,
                growthToday: userGrowthToday,
                growthThisMonth: userGrowthThisMonth
            },
            transactionStats: {
                total: totalTransactions,
                successful: successfulTransactions,
                pending: pendingTransactions,
                failed: failedTransactions,
                successRate: totalTransactions > 0 ? (successfulTransactions / totalTransactions * 100) : 0,
                volumeToday: todayTransactions[0]?.total || 0,
                volumeYesterday: yesterdayTransactions[0]?.total || 0,
                volumeThisMonth: thisMonthTransactions[0]?.total || 0,
                countToday: todayTransactions[0]?.count || 0,
                countYesterday: yesterdayTransactions[0]?.count || 0,
                countThisMonth: thisMonthTransactions[0]?.count || 0,
                growthPercentage: Math.round(transactionGrowthPercentage * 100) / 100
            },
            disputeStats: {
                total: totalDisputes,
                open: openDisputes,
                resolved: resolvedDisputes,
                resolutionRate: totalDisputes > 0 ? (resolvedDisputes / totalDisputes * 100) : 0
            },
            walletStats: {
                total: totalWallets,
                totalBalance: totalBalance[0]?.total || 0,
                averageBalance: totalWallets > 0 ? (totalBalance[0]?.total || 0) / totalWallets : 0
            }
        };
        res.json({
            success: true,
            data: dashboardData
        });
    }
    catch (error) {
        console.error('Analytics dashboard error:', error);
        res.status(500).json({
            success: false,
            error: 'Failed to fetch dashboard analytics',
            message: error.message
        });
    }
}));
router.get('/transactions', (0, errors_1.asyncHandler)(async (req, res) => {
    try {
        const { Transaction } = await Promise.resolve().then(() => __importStar(require('../database/models/transactions')));
        const { period = '7d', type, category, status } = req.query;
        const now = new Date();
        let startDate;
        switch (period) {
            case '1d':
                startDate = new Date(now.getTime() - 24 * 60 * 60 * 1000);
                break;
            case '7d':
                startDate = new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000);
                break;
            case '30d':
                startDate = new Date(now.getTime() - 30 * 24 * 60 * 60 * 1000);
                break;
            case '90d':
                startDate = new Date(now.getTime() - 90 * 24 * 60 * 60 * 1000);
                break;
            default:
                startDate = new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000);
        }
        const matchCriteria = {
            createdAt: { $gte: startDate }
        };
        if (type)
            matchCriteria.type = type;
        if (category)
            matchCriteria.category = category;
        if (status)
            matchCriteria.status = status;
        const analytics = await Transaction.aggregate([
            { $match: matchCriteria },
            {
                $group: {
                    _id: {
                        date: { $dateToString: { format: '%Y-%m-%d', date: '$createdAt' } },
                        status: '$status',
                        type: '$type',
                        category: '$category'
                    },
                    count: { $sum: 1 },
                    totalAmount: { $sum: '$amount' },
                    averageAmount: { $avg: '$amount' }
                }
            },
            { $sort: { '_id.date': 1 } }
        ]);
        const summary = await Transaction.aggregate([
            { $match: matchCriteria },
            {
                $group: {
                    _id: null,
                    totalCount: { $sum: 1 },
                    totalAmount: { $sum: '$amount' },
                    averageAmount: { $avg: '$amount' },
                    successfulCount: {
                        $sum: { $cond: [{ $eq: ['$status', 'successful'] }, 1, 0] }
                    },
                    pendingCount: {
                        $sum: { $cond: [{ $eq: ['$status', 'pending'] }, 1, 0] }
                    },
                    failedCount: {
                        $sum: { $cond: [{ $eq: ['$status', 'failed'] }, 1, 0] }
                    }
                }
            }
        ]);
        res.json({
            success: true,
            data: {
                analytics,
                summary: summary[0] || {
                    totalCount: 0,
                    totalAmount: 0,
                    averageAmount: 0,
                    successfulCount: 0,
                    pendingCount: 0,
                    failedCount: 0
                },
                period,
                startDate,
                endDate: now
            }
        });
    }
    catch (error) {
        console.error('Transaction analytics error:', error);
        res.status(500).json({
            success: false,
            error: 'Failed to fetch transaction analytics',
            message: error.message
        });
    }
}));
router.get('/users', (0, errors_1.asyncHandler)(async (req, res) => {
    try {
        const { User } = await Promise.resolve().then(() => __importStar(require('../modules/users/user.model')));
        const { period = '30d' } = req.query;
        const now = new Date();
        let startDate;
        switch (period) {
            case '7d':
                startDate = new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000);
                break;
            case '30d':
                startDate = new Date(now.getTime() - 30 * 24 * 60 * 60 * 1000);
                break;
            case '90d':
                startDate = new Date(now.getTime() - 90 * 24 * 60 * 60 * 1000);
                break;
            default:
                startDate = new Date(now.getTime() - 30 * 24 * 60 * 60 * 1000);
        }
        const analytics = await User.aggregate([
            {
                $match: {
                    createdAt: { $gte: startDate },
                    isDeleted: { $ne: true }
                }
            },
            {
                $group: {
                    _id: {
                        date: { $dateToString: { format: '%Y-%m-%d', date: '$createdAt' } },
                        role: '$role'
                    },
                    count: { $sum: 1 }
                }
            },
            { $sort: { '_id.date': 1 } }
        ]);
        const summary = await User.aggregate([
            {
                $match: {
                    isDeleted: { $ne: true }
                }
            },
            {
                $group: {
                    _id: null,
                    totalUsers: { $sum: 1 },
                    adminUsers: {
                        $sum: { $cond: [{ $eq: ['$role', 'admin'] }, 1, 0] }
                    },
                    regularUsers: {
                        $sum: { $cond: [{ $eq: ['$role', 'user'] }, 1, 0] }
                    },
                    verifiedUsers: {
                        $sum: { $cond: [{ $eq: ['$isEmailVerified', true] }, 1, 0] }
                    },
                    activeUsers: {
                        $sum: {
                            $cond: [
                                { $gte: ['$lastLoginAt', new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000)] },
                                1,
                                0
                            ]
                        }
                    }
                }
            }
        ]);
        res.json({
            success: true,
            data: {
                analytics,
                summary: summary[0] || {
                    totalUsers: 0,
                    adminUsers: 0,
                    regularUsers: 0,
                    verifiedUsers: 0,
                    activeUsers: 0
                },
                period,
                startDate,
                endDate: now
            }
        });
    }
    catch (error) {
        console.error('User analytics error:', error);
        res.status(500).json({
            success: false,
            error: 'Failed to fetch user analytics',
            message: error.message
        });
    }
}));
router.get('/revenue', (0, errors_1.asyncHandler)(async (req, res) => {
    try {
        const { Transaction } = await Promise.resolve().then(() => __importStar(require('../database/models/transactions')));
        const { period = '30d', currency = 'NGN' } = req.query;
        const now = new Date();
        let startDate;
        switch (period) {
            case '7d':
                startDate = new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000);
                break;
            case '30d':
                startDate = new Date(now.getTime() - 30 * 24 * 60 * 60 * 1000);
                break;
            case '90d':
                startDate = new Date(now.getTime() - 90 * 24 * 60 * 60 * 1000);
                break;
            default:
                startDate = new Date(now.getTime() - 30 * 24 * 60 * 60 * 1000);
        }
        const analytics = await Transaction.aggregate([
            {
                $match: {
                    createdAt: { $gte: startDate },
                    status: 'successful',
                    currency: currency
                }
            },
            {
                $group: {
                    _id: {
                        date: { $dateToString: { format: '%Y-%m-%d', date: '$createdAt' } },
                        category: '$category'
                    },
                    revenue: { $sum: '$amount' },
                    transactionCount: { $sum: 1 },
                    averageTransaction: { $avg: '$amount' }
                }
            },
            { $sort: { '_id.date': 1 } }
        ]);
        const summary = await Transaction.aggregate([
            {
                $match: {
                    createdAt: { $gte: startDate },
                    status: 'successful',
                    currency: currency
                }
            },
            {
                $group: {
                    _id: null,
                    totalRevenue: { $sum: '$amount' },
                    totalTransactions: { $sum: 1 },
                    averageTransaction: { $avg: '$amount' },
                    maxTransaction: { $max: '$amount' },
                    minTransaction: { $min: '$amount' }
                }
            }
        ]);
        res.json({
            success: true,
            data: {
                analytics,
                summary: summary[0] || {
                    totalRevenue: 0,
                    totalTransactions: 0,
                    averageTransaction: 0,
                    maxTransaction: 0,
                    minTransaction: 0
                },
                period,
                currency,
                startDate,
                endDate: now
            }
        });
    }
    catch (error) {
        console.error('Revenue analytics error:', error);
        res.status(500).json({
            success: false,
            error: 'Failed to fetch revenue analytics',
            message: error.message
        });
    }
}));
exports.default = router;
