"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const service_provider_controller_1 = require("../modules/admin/services/service-provider.controller");
const auth_1 = require("../core/middleware/auth");
const vat_config_controller_1 = require("../modules/admin/services/vat-config.controller");
const verification_pricing_controller_1 = require("../modules/admin/services/verification-pricing.controller");
const verification_provider_controller_1 = require("../modules/admin/services/verification-provider.controller");
const ninslip_admin_controller_1 = require("../modules/admin/services/ninslip.admin.controller");
const payment_provider_controller_1 = require("../modules/admin/services/payment-provider.controller");
const wallet_config_controller_1 = require("../modules/admin/services/wallet-config.controller");
const auth_config_controller_1 = require("../modules/admin/services/auth-config.controller");
const errors_1 = require("../core/errors");
const router = (0, express_1.Router)();
router.use(auth_1.requireAuth);
router.use((0, auth_1.requireRole)('admin'));
router.post('/providers', service_provider_controller_1.ServiceProviderController.createProvider);
router.get('/providers', service_provider_controller_1.ServiceProviderController.getProviders);
router.get('/providers/stats', service_provider_controller_1.ServiceProviderController.getProviders);
router.get('/providers/service-type/:serviceType', service_provider_controller_1.ServiceProviderController.getProvidersByServiceType);
router.get('/providers/active/:serviceType', service_provider_controller_1.ServiceProviderController.getActiveProviders);
router.get('/providers/:id', service_provider_controller_1.ServiceProviderController.getProvider);
router.put('/providers/:id', service_provider_controller_1.ServiceProviderController.updateProvider);
router.delete('/providers/:id', service_provider_controller_1.ServiceProviderController.deleteProvider);
router.post('/providers/:id/health-check', service_provider_controller_1.ServiceProviderController.testProviderHealth);
router.patch('/providers/:id/priority', service_provider_controller_1.ServiceProviderController.updateProviderPriority);
router.patch('/providers/:id/toggle-status', service_provider_controller_1.ServiceProviderController.toggleProviderStatus);
exports.default = router;
router.get('/configs/vat', vat_config_controller_1.VatConfigController.list);
router.get('/configs/vat/:serviceCategory', vat_config_controller_1.VatConfigController.getByServiceCategory);
router.post('/configs/vat', vat_config_controller_1.VatConfigController.createOrUpdate);
router.patch('/configs/vat/:serviceCategory', vat_config_controller_1.VatConfigController.createOrUpdate);
router.delete('/configs/vat/:serviceCategory', vat_config_controller_1.VatConfigController.disable);
router.get('/products', (0, errors_1.asyncHandler)(async (_req, res) => {
    const Product = (await Promise.resolve().then(() => __importStar(require('../database/models/product')))).Product;
    const products = await Product.find({ isDeleted: { $ne: true } }).limit(200).exec();
    res.json({ success: true, data: products });
}));
router.post('/products', (0, errors_1.asyncHandler)(async (req, res) => {
    const Product = (await Promise.resolve().then(() => __importStar(require('../database/models/product')))).Product;
    const created = await Product.create(req.body);
    res.status(201).json({ success: true, data: created });
}));
router.patch('/products/:id', (0, errors_1.asyncHandler)(async (req, res) => {
    const Product = (await Promise.resolve().then(() => __importStar(require('../database/models/product')))).Product;
    const updated = await Product.findByIdAndUpdate(req.params.id, req.body, { new: true }).exec();
    res.json({ success: true, data: updated });
}));
router.delete('/products/:id', (0, errors_1.asyncHandler)(async (req, res) => {
    const Product = (await Promise.resolve().then(() => __importStar(require('../database/models/product')))).Product;
    const updated = await Product.findByIdAndUpdate(req.params.id, { isDeleted: true, deletedAt: new Date() }, { new: true }).exec();
    res.json({ success: true, data: updated });
}));
router.get('/configs/verification-prices', verification_pricing_controller_1.VerificationPricingController.list);
router.get('/configs/verification-prices/:service', verification_pricing_controller_1.VerificationPricingController.getByService);
router.post('/configs/verification-prices/:service', verification_pricing_controller_1.VerificationPricingController.upsert);
router.patch('/configs/verification-prices/:service', verification_pricing_controller_1.VerificationPricingController.upsert);
router.get('/configs/verification-subservice-prices', verification_pricing_controller_1.VerificationPricingController.listSubServices);
router.get('/configs/verification-subservice-prices/:subService', verification_pricing_controller_1.VerificationPricingController.getBySubService);
router.post('/configs/verification-subservice-prices/:subService', verification_pricing_controller_1.VerificationPricingController.upsertSubService);
router.patch('/configs/verification-subservice-prices/:subService', verification_pricing_controller_1.VerificationPricingController.upsertSubService);
router.post('/configs/verification-subservice-prices/bulk-update', verification_pricing_controller_1.VerificationPricingController.bulkUpdateSubServices);
router.post('/ninslips/:trackingId/purge', ninslip_admin_controller_1.NinSlipAdminController.purge);
router.post('/ninslips/:trackingId/rebuild', ninslip_admin_controller_1.NinSlipAdminController.rebuild);
router.get('/verification/providers', (0, errors_1.asyncHandler)(verification_provider_controller_1.VerificationProviderController.getAvailableProviders));
router.get('/verification/providers/current', (0, errors_1.asyncHandler)(verification_provider_controller_1.VerificationProviderController.getCurrentProvider));
router.post('/verification/providers/set', verification_provider_controller_1.VerificationProviderController.setProvider);
router.put('/verification/providers/:provider/config', verification_provider_controller_1.VerificationProviderController.updateProviderConfig);
router.post('/verification/providers/:provider/test', verification_provider_controller_1.VerificationProviderController.testProvider);
router.get('/verification/providers/:provider/health', (0, errors_1.asyncHandler)(verification_provider_controller_1.VerificationProviderController.getProviderHealth));
router.get('/verification/config/status', (0, errors_1.asyncHandler)(verification_provider_controller_1.VerificationProviderController.getConfigStatus));
router.get('/verification/providers/:provider/:subService/verify-credentials', (0, errors_1.asyncHandler)(verification_provider_controller_1.VerificationProviderController.verifyProviderCredentials));
router.get('/payment/providers', (0, errors_1.asyncHandler)(payment_provider_controller_1.PaymentProviderController.getAvailableProviders));
router.get('/payment/providers/current', (0, errors_1.asyncHandler)(payment_provider_controller_1.PaymentProviderController.getCurrentProvider));
router.post('/payment/providers/set', payment_provider_controller_1.PaymentProviderController.setProvider);
router.put('/payment/providers/:provider/config', payment_provider_controller_1.PaymentProviderController.updateProviderConfig);
router.post('/payment/providers/:provider/test', payment_provider_controller_1.PaymentProviderController.testProvider);
router.get('/payment/providers/:provider/health', (0, errors_1.asyncHandler)(payment_provider_controller_1.PaymentProviderController.getProviderHealth));
router.get('/wallet/config', (0, errors_1.asyncHandler)(wallet_config_controller_1.WalletConfigController.getWalletConfig));
router.put('/wallet/config', wallet_config_controller_1.WalletConfigController.updateWalletConfig);
router.post('/wallet/transaction-limits', wallet_config_controller_1.WalletConfigController.setTransactionLimits);
router.post('/wallet/fees', wallet_config_controller_1.WalletConfigController.setFees);
router.get('/wallet/stats', (0, errors_1.asyncHandler)(wallet_config_controller_1.WalletConfigController.getWalletStats));
router.get('/auth/config', (0, errors_1.asyncHandler)(auth_config_controller_1.AuthConfigController.getAuthConfig));
router.put('/auth/config', auth_config_controller_1.AuthConfigController.updateAuthConfig);
router.post('/auth/password-policy', auth_config_controller_1.AuthConfigController.setPasswordPolicy);
router.post('/auth/rate-limiting', auth_config_controller_1.AuthConfigController.setRateLimiting);
router.get('/auth/stats', (0, errors_1.asyncHandler)(auth_config_controller_1.AuthConfigController.getAuthStats));
