"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const router = (0, express_1.Router)();
router.use('/ui', swagger_ui_express_1.default.serve);
router.get('/ui', swagger_ui_express_1.default.setup(undefined, {
    customCss: `
    .swagger-ui .topbar { display: none }
    .swagger-ui .info { margin: 20px 0 }
    .swagger-ui .info .title { color: #2c3e50; font-size: 2em; }
    .swagger-ui .scheme-container { background: #f8f9fa; padding: 15px; border-radius: 5px; }
  `,
    customSiteTitle: 'Unify Admin API Documentation',
    customfavIcon: '/favicon.ico',
    swaggerOptions: {
        url: '/openapi.json',
        persistAuthorization: true,
        displayRequestDuration: true,
        docExpansion: 'list',
        filter: true,
        showExtensions: true,
        showCommonExtensions: true,
        tryItOutEnabled: true,
    }
}));
router.get('/spec', (req, res) => {
    res.redirect('/openapi.json');
});
router.get('/spec.yaml', (req, res) => {
    res.redirect('/openapi.json');
});
router.get('/', (req, res) => {
    res.json({
        success: true,
        message: 'Unify Admin API Documentation',
        endpoints: {
            'Swagger UI': '/api/v1/admin/docs/ui',
            'OpenAPI Spec (JSON)': '/api/v1/admin/docs/spec',
            'OpenAPI Spec (YAML)': '/api/v1/admin/docs/spec.yaml',
        },
        description: 'Comprehensive API documentation for the Unify admin panel',
        version: '1.0.0',
        features: [
            'Service Provider Management',
            'Service Plan Management',
            'System Configuration',
            'Health Monitoring',
            'Interactive API Testing'
        ]
    });
});
exports.default = router;
