"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FEE_STRUCTURES = exports.ACCOUNT_CODES = exports.InvalidFeeStructureError = exports.DuplicateReferenceError = exports.UnbalancedTransactionError = exports.InvalidLedgerEntryError = exports.InsufficientBalanceError = void 0;
class InsufficientBalanceError extends Error {
    constructor(message = 'Insufficient balance') {
        super(message);
        this.name = 'InsufficientBalanceError';
    }
}
exports.InsufficientBalanceError = InsufficientBalanceError;
class InvalidLedgerEntryError extends Error {
    constructor(message = 'Invalid ledger entry') {
        super(message);
        this.name = 'InvalidLedgerEntryError';
    }
}
exports.InvalidLedgerEntryError = InvalidLedgerEntryError;
class UnbalancedTransactionError extends Error {
    constructor(message = 'Transaction is not balanced') {
        super(message);
        this.name = 'UnbalancedTransactionError';
    }
}
exports.UnbalancedTransactionError = UnbalancedTransactionError;
class DuplicateReferenceError extends Error {
    constructor(message = 'Duplicate reference') {
        super(message);
        this.name = 'DuplicateReferenceError';
    }
}
exports.DuplicateReferenceError = DuplicateReferenceError;
class InvalidFeeStructureError extends Error {
    constructor(message = 'Invalid fee structure') {
        super(message);
        this.name = 'InvalidFeeStructureError';
    }
}
exports.InvalidFeeStructureError = InvalidFeeStructureError;
exports.ACCOUNT_CODES = {
    CASH: '1000',
    BANK_ACCOUNTS: '1100',
    CUSTOMER_WALLETS: '1200',
    RECEIVABLES: '1300',
    PAYABLES: '2000',
    FEES_PAYABLE: '2100',
    VAT_PAYABLE: '2200',
    RETAINED_EARNINGS: '3000',
    FEES_EARNED: '3100',
    TRANSACTION_FEES: '4000',
    SERVICE_FEES: '4100',
    OPERATING_EXPENSES: '5000',
    BANK_CHARGES: '5100',
    PAYMENT_PROCESSOR_FEES: '5200',
};
exports.FEE_STRUCTURES = {
    funding: {
        type: 'percentage',
        value: 0.015,
        minAmount: 100,
        currency: 'NGN',
        vatRate: 0.075,
    },
    withdrawal: {
        type: 'fixed',
        value: 100,
        currency: 'NGN',
        vatRate: 0.075,
    },
    transfer: {
        type: 'percentage',
        value: 0.01,
        minAmount: 50,
        currency: 'NGN',
        vatRate: 0.075,
    },
    vtu: {
        type: 'fixed',
        value: 50,
        currency: 'NGN',
        vatRate: 0.075,
    },
    bill_payment: {
        type: 'fixed',
        value: 100,
        currency: 'NGN',
        vatRate: 0.075,
    },
};
