import { TransactionCategory, TransactionStatus } from '../../database/models/transactions';
import { FundingMethod, FundingType } from '../../database/models/funding';
import { WithdrawalMethod, WithdrawalType } from '../../database/models/withdrawal';
import { DisputeType, DisputePriority } from '../../database/models/dispute';
import { AccountType, EntryType } from '../../database/models/ledger';
export interface WalletBalance {
    availableBalance: number;
    ledgerBalance: number;
    currency: 'NGN' | 'USD';
    lastTransactionAt?: Date;
}
export interface WalletSummary {
    userId: string;
    balances: WalletBalance[];
    totalTransactions: number;
    totalVolume: number;
    lastActivity: Date;
}
export interface LedgerEntry {
    accountType: AccountType;
    accountCode: string;
    entryType: EntryType;
    amount: number;
    currency: 'NGN' | 'USD';
    description: string;
    reference: string;
    metadata?: Record<string, any>;
}
export interface LedgerTransaction {
    transactionId: string;
    entries: LedgerEntry[];
    totalDebits: number;
    totalCredits: number;
    isBalanced: boolean;
}
export interface FundingRequest {
    userId: string;
    amount: number;
    currency: 'NGN' | 'USD';
    method: FundingMethod;
    type: FundingType;
    bankDetails?: {
        bankName: string;
        accountNumber: string;
        accountName: string;
        narration?: string;
    };
    cardDetails?: {
        last4: string;
        brand: string;
        expiryMonth: number;
        expiryYear: number;
    };
    scheduledAt?: Date;
    metadata?: Record<string, any>;
}
export interface FundingResponse {
    funding: any;
    transaction?: any;
    ledgerEntries: LedgerEntry[];
    bankDetails?: {
        bankName: string;
        accountNumber: string;
        accountName: string;
        narration: string;
    };
    paymentUrl?: string;
    reference: string;
}
export interface WithdrawalRequest {
    userId: string;
    amount: number;
    currency: 'NGN' | 'USD';
    method: WithdrawalMethod;
    type: WithdrawalType;
    bankDetails?: {
        bankName: string;
        accountNumber: string;
        accountName: string;
        narration?: string;
    };
    mobileMoneyDetails?: {
        provider: string;
        phoneNumber: string;
        accountName: string;
    };
    scheduledAt?: Date;
    metadata?: Record<string, any>;
}
export interface WithdrawalResponse {
    withdrawal: any;
    transaction?: any;
    ledgerEntries: LedgerEntry[];
    reference: string;
    estimatedProcessingTime?: string;
}
export interface FeeStructure {
    type: 'percentage' | 'fixed' | 'tiered';
    value: number;
    minAmount?: number;
    maxAmount?: number;
    currency: 'NGN' | 'USD';
    vatRate: number;
}
export interface FeeCalculation {
    baseAmount: number;
    fee: number;
    vat: number;
    totalFee: number;
    netAmount: number;
    currency: 'NGN' | 'USD';
}
export interface TransactionFilter {
    userId?: string;
    walletId?: string;
    type?: 'credit' | 'debit';
    category?: TransactionCategory;
    status?: TransactionStatus;
    currency?: 'NGN' | 'USD';
    dateFrom?: Date;
    dateTo?: Date;
    minAmount?: number;
    maxAmount?: number;
    reference?: string;
    externalReference?: string;
}
export interface TransactionSearchParams {
    filter: TransactionFilter;
    page: number;
    limit: number;
    sortBy?: 'amount' | 'createdAt' | 'reference';
    sortOrder?: 'asc' | 'desc';
}
export interface TransactionSearchResult {
    transactions: any[];
    total: number;
    page: number;
    limit: number;
    totalPages: number;
    hasNext: boolean;
    hasPrev: boolean;
}
export interface DisputeRequest {
    userId: string;
    transactionId: string;
    type: DisputeType;
    priority: DisputePriority;
    reason: string;
    description: string;
    evidence?: {
        documents: string[];
        notes: string;
    };
    metadata?: Record<string, any>;
}
export interface DisputeResponse {
    dispute: any;
    reference: string;
    estimatedResolutionTime?: string;
}
export interface ReconciliationRequest {
    provider: string;
    type: 'daily' | 'weekly' | 'monthly' | 'manual';
    dateFrom: Date;
    dateTo: Date;
    metadata?: Record<string, any>;
}
export interface ReconciliationResult {
    reconciliation: any;
    discrepancies: Array<{
        type: string;
        internalReference: string;
        externalReference?: string;
        description: string;
        severity: 'low' | 'medium' | 'high';
    }>;
    summary: {
        totalProcessed: number;
        totalMatched: number;
        totalDiscrepancies: number;
        matchRate: number;
    };
}
export interface ExportRequest {
    userId?: string;
    filter: TransactionFilter;
    format: 'csv' | 'xlsx' | 'pdf';
    includeMetadata?: boolean;
}
export interface ExportResult {
    downloadUrl: string;
    filename: string;
    expiresAt: Date;
    recordCount: number;
}
export interface AccountChart {
    code: string;
    name: string;
    type: AccountType;
    parentCode?: string;
    description?: string;
    isActive: boolean;
}
export interface AccountBalance {
    accountCode: string;
    accountName: string;
    accountType: AccountType;
    debitBalance: number;
    creditBalance: number;
    netBalance: number;
    currency: 'NGN' | 'USD';
    lastUpdated: Date;
}
export declare class InsufficientBalanceError extends Error {
    constructor(message?: string);
}
export declare class InvalidLedgerEntryError extends Error {
    constructor(message?: string);
}
export declare class UnbalancedTransactionError extends Error {
    constructor(message?: string);
}
export declare class DuplicateReferenceError extends Error {
    constructor(message?: string);
}
export declare class InvalidFeeStructureError extends Error {
    constructor(message?: string);
}
export declare const ACCOUNT_CODES: {
    readonly CASH: "1000";
    readonly BANK_ACCOUNTS: "1100";
    readonly CUSTOMER_WALLETS: "1200";
    readonly RECEIVABLES: "1300";
    readonly PAYABLES: "2000";
    readonly FEES_PAYABLE: "2100";
    readonly VAT_PAYABLE: "2200";
    readonly RETAINED_EARNINGS: "3000";
    readonly FEES_EARNED: "3100";
    readonly TRANSACTION_FEES: "4000";
    readonly SERVICE_FEES: "4100";
    readonly OPERATING_EXPENSES: "5000";
    readonly BANK_CHARGES: "5100";
    readonly PAYMENT_PROCESSOR_FEES: "5200";
};
export declare const FEE_STRUCTURES: Record<string, FeeStructure>;
