import { WalletDocument } from '../../database/models/wallet';
import { TransactionCategory, TransactionDocument } from '../../database/models/transactions';
export interface DebitParams {
    userId: string;
    currency: 'NGN' | 'USD';
    amount: number;
    reference: string;
    category: TransactionCategory;
    description?: string;
    metadata?: Record<string, any>;
    feeAmount?: number;
    vatAmount?: number;
}
export interface CreditParams extends DebitParams {
}
export interface FeeCalculation {
    feeAmount: number;
    vatAmount: number;
    netAmount: number;
}
export declare class WalletService {
    private validateTransactionParams;
    private logTransaction;
    private calculateFees;
    private generateJournalEntryId;
    private ensureIdempotency;
    private getOrCreateWallet;
    debit(params: DebitParams): Promise<{
        transaction: TransactionDocument;
        wallet: WalletDocument;
    }>;
    credit(params: CreditParams): Promise<{
        transaction: TransactionDocument;
        wallet: WalletDocument;
    }>;
    createReversal(originalTransactionId: string, reason: string): Promise<TransactionDocument>;
    getWallet(userId: string, currency: 'NGN' | 'USD'): Promise<WalletDocument>;
    getUserBalances(userId: string): Promise<Array<{
        currency: 'NGN' | 'USD';
        availableBalance: number;
        ledgerBalance: number;
    }>>;
    getUserBalanceByCurrency(userId: string, currency: 'NGN' | 'USD'): Promise<{
        currency: 'NGN' | 'USD';
        availableBalance: number;
        ledgerBalance: number;
    }>;
}
export declare const walletService: WalletService;
