"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const validate_1 = require("../../core/validate");
const vtu_service_1 = require("./vtu.service");
const router = (0, express_1.Router)();
router.post('/buy', auth_1.requireAuth, (0, validate_1.validate)(validate_1.vtuBuySchema), async (req, res) => {
    try {
        const { amount, currency, reference, type, network, phone, planCode } = req.body || {};
        if (!amount || !reference || !type || !network || !phone) {
            res.status(400).json({ error: 'amount, reference, type, network, phone are required' });
            return;
        }
        const result = await vtu_service_1.vtuService.buyVtu({ userId: req.user.userId, amount, currency, reference, type, network, phone, planCode });
        res.status(200).json({ order: result.order });
    }
    catch (e) {
        res.status(400).json({ error: e.message || 'Failed to buy VTU' });
    }
});
exports.default = router;
