"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.enhancedVtuService = exports.EnhancedVtuService = void 0;
const wallet_service_1 = require("../wallet/wallet.service");
const vtu_1 = require("../../database/repositories/vtu");
const transactions_1 = require("../../database/repositories/transactions");
const configurable_service_manager_1 = require("../../integrations/configurable-service-manager");
const errors_1 = require("../../core/errors");
class EnhancedVtuService {
    async buyVtu(params) {
        const existingTx = await transactions_1.transactionRepository.findByReference(params.reference);
        if (existingTx) {
            const existingOrder = await vtu_1.vtuRepository.findOne({ transactionId: existingTx.id });
            if (existingOrder)
                return { order: existingOrder };
        }
        let finalAmount = params.amount;
        let planCode = params.vendorPlanCode;
        let planDetails = null;
        if (params.planId) {
            const { ProductRepository } = await Promise.resolve().then(() => __importStar(require('../../database/repositories/product.repo')));
            const productRepo = new ProductRepository();
            planDetails = await productRepo.findByCanonicalCode(params.planId);
            if (!planDetails) {
                throw new errors_1.AppError('Selected plan not found', 404);
            }
            if (!planDetails.isVisible || planDetails.isDeleted) {
                throw new errors_1.AppError('Selected plan is not available', 400);
            }
            finalAmount = planDetails.sellingPrice || planDetails.providers?.[0]?.costPrice || 0;
            planCode = planDetails.providers?.[0]?.vendorCode || planDetails.canonicalCode;
        }
        else if (params.type === 'data' && !planCode) {
            throw new errors_1.AppError('Plan ID or vendor plan code is required for data purchases', 400);
        }
        if (!finalAmount) {
            throw new errors_1.AppError('Amount could not be determined', 400);
        }
        const order = await vtu_1.vtuRepository.create({
            userId: params.userId,
            type: params.type,
            network: params.network,
            phone: params.phone,
            amount: finalAmount,
            planCode: planCode,
            status: 'pending',
            provider: 'configurable',
            metadata: {
                planId: params.planId,
                dataPlanType: params.dataPlanType,
                planDetails: planDetails ? {
                    name: planDetails.name,
                    size: planDetails.size,
                    validity: planDetails.validity,
                } : undefined,
            }
        });
        const { transaction } = await wallet_service_1.walletService.debit({
            userId: params.userId,
            currency: params.currency,
            amount: finalAmount,
            reference: params.reference,
            category: 'vtu',
            description: `${params.type} purchase on ${params.network} for ${params.phone}${planDetails ? ` - ${planDetails.name}` : ''}`,
            metadata: { orderId: order.id, planId: params.planId }
        });
        const updatedOrder = await vtu_1.vtuRepository.updateById(order.id, {
            transactionId: transaction.id,
            status: 'processing'
        });
        if (!updatedOrder)
            throw new Error('Failed to update VTU order');
        try {
            const vtuRequest = {
                amount: finalAmount,
                type: params.type,
                network: params.network,
                phone: params.phone,
                planCode: planCode,
                reference: params.reference,
                metadata: {
                    orderId: order.id,
                    planId: params.planId,
                    userId: params.userId,
                }
            };
            const result = await configurable_service_manager_1.configurableServiceManager.executeVtuPurchase(vtuRequest);
            if (result.success) {
                await vtu_1.vtuRepository.updateById(updatedOrder.id, {
                    status: 'successful',
                    providerReference: result.providerReference,
                    metadata: {
                        ...updatedOrder.metadata,
                        providerResponse: result.meta,
                        completedAt: new Date(),
                    },
                });
            }
            else {
                await vtu_1.vtuRepository.updateById(updatedOrder.id, {
                    status: 'failed',
                    metadata: {
                        ...updatedOrder.metadata,
                        providerResponse: result.meta,
                        failureReason: result.message,
                        failedAt: new Date(),
                    }
                });
                const reversalRef = `${params.reference}-reversal`;
                await wallet_service_1.walletService.credit({
                    userId: params.userId,
                    currency: params.currency,
                    amount: finalAmount,
                    reference: reversalRef,
                    category: 'reversal',
                    description: `Reversal for failed vtu ${params.reference}`,
                    metadata: { originalReference: params.reference, orderId: updatedOrder.id }
                });
            }
        }
        catch (error) {
            await vtu_1.vtuRepository.updateById(updatedOrder.id, {
                status: 'failed',
                metadata: {
                    ...updatedOrder.metadata,
                    error: error instanceof Error ? error.message : 'Unknown error',
                    failedAt: new Date(),
                }
            });
            const reversalRef = `${params.reference}-reversal`;
            await wallet_service_1.walletService.credit({
                userId: params.userId,
                currency: params.currency,
                amount: finalAmount,
                reference: reversalRef,
                category: 'reversal',
                description: `Reversal for failed vtu ${params.reference}`,
                metadata: { originalReference: params.reference, orderId: updatedOrder.id }
            });
            throw error;
        }
        const finalOrder = await vtu_1.vtuRepository.findById(updatedOrder.id);
        if (!finalOrder)
            throw new Error('VTU order not found after update');
        return { order: finalOrder };
    }
    async getDataPlans(network, dataPlanType) {
        const plans = await configurable_service_manager_1.configurableServiceManager.getServicePlans('data', network, { dataPlanType });
        return plans.map(plan => ({
            id: plan.planId,
            name: plan.name,
            network: plan.network,
            size: plan.size,
            validity: plan.validity,
            price: plan.sellingPrice,
            planCode: plan.vendorPlanId || plan.planId,
            description: plan.description,
            dataPlanType: plan.dataPlanType,
            provider: {
                id: plan.providerId,
                name: plan.providerId.displayName || plan.providerId.name,
            },
            metadata: plan.metadata,
        }));
    }
    async getNetworksWithPlans() {
        const networks = ['mtn', 'airtel', 'glo', '9mobile'];
        const result = [];
        for (const network of networks) {
            const plans = await this.getDataPlans(network);
            result.push({
                network,
                name: network.toUpperCase(),
                plans,
                available: plans.length > 0,
            });
        }
        return result;
    }
    validatePhoneAndNetwork(phone, network) {
        const cleanPhone = phone.replace(/\D/g, '');
        let normalizedPhone = cleanPhone;
        if (cleanPhone.startsWith('234')) {
            normalizedPhone = cleanPhone;
        }
        else if (cleanPhone.startsWith('0')) {
            normalizedPhone = '234' + cleanPhone.substring(1);
        }
        else if (cleanPhone.length === 10) {
            normalizedPhone = '234' + cleanPhone;
        }
        if (normalizedPhone.length !== 13) {
            return { isValid: false, normalizedPhone };
        }
        const prefix = normalizedPhone.substring(3, 6);
        let detectedNetwork;
        if (['803', '806', '813', '816', '903', '906', '913', '916'].includes(prefix)) {
            detectedNetwork = 'mtn';
        }
        else if (['802', '808', '812', '901', '902', '904', '907', '912'].includes(prefix)) {
            detectedNetwork = 'airtel';
        }
        else if (['805', '807', '811', '815', '905', '915'].includes(prefix)) {
            detectedNetwork = 'glo';
        }
        else if (['809', '817', '818', '909', '908'].includes(prefix)) {
            detectedNetwork = '9mobile';
        }
        const isValid = detectedNetwork === network;
        return {
            isValid,
            normalizedPhone,
            detectedNetwork,
        };
    }
    async getServiceStats() {
        return configurable_service_manager_1.configurableServiceManager.getServiceStats();
    }
    async checkServiceAvailability(service) {
        return configurable_service_manager_1.configurableServiceManager.validateServiceAvailability('vtu', service);
    }
}
exports.EnhancedVtuService = EnhancedVtuService;
exports.enhancedVtuService = new EnhancedVtuService();
