import { VtuOrderDocument, VtuType, Network } from '../../database/models/vtu';
export interface EnhancedBuyVtuParams {
    userId: string;
    currency: 'NGN' | 'USD';
    amount?: number;
    type: VtuType;
    network: Network;
    phone: string;
    planId?: string;
    vendorPlanCode?: string;
    reference: string;
    dataPlanType?: string;
}
export declare class EnhancedVtuService {
    buyVtu(params: EnhancedBuyVtuParams): Promise<{
        order: VtuOrderDocument;
    }>;
    getDataPlans(network: Network, dataPlanType?: string): Promise<any[]>;
    getNetworksWithPlans(): Promise<any[]>;
    validatePhoneAndNetwork(phone: string, network: Network): {
        isValid: boolean;
        normalizedPhone: string;
        detectedNetwork?: Network;
    };
    getServiceStats(): Promise<any>;
    checkServiceAvailability(service: string): Promise<boolean>;
}
export declare const enhancedVtuService: EnhancedVtuService;
