import { VtuResponse, BillResponse, ElectricityValidationResponse, CableValidationResponse, ExamPinResponse, DataPlan, NetworkInfo, TransactionQuery, Network, VtuType, BillType, MeterType, CableProvider, ElectricityProvider } from '../../integrations/vtu-bills/vtu-bills.types';
import { VtuOrderDocument } from '../../database/models/vtu';
export interface BuyVtuParams {
    userId: string;
    currency: 'NGN' | 'USD';
    amount: number;
    type: VtuType;
    network: Network;
    phone: string;
    planCode?: string;
    reference: string;
    provider?: string;
}
export interface PayBillParams {
    userId: string;
    currency: 'NGN' | 'USD';
    amount: number;
    type: BillType;
    provider: string;
    customerId: string;
    reference: string;
    metadata?: Record<string, any>;
}
export interface BuyExamPinParams {
    userId: string;
    currency: 'NGN' | 'USD';
    amount: number;
    examType: string;
    quantity: number;
    reference: string;
    provider?: string;
}
export declare class VtuBillsService {
    private static instance;
    private constructor();
    static getInstance(): VtuBillsService;
    buyVtu(params: BuyVtuParams): Promise<{
        order: VtuOrderDocument;
        response: VtuResponse;
    }>;
    getDataPlans(network: Network, planType?: string): Promise<DataPlan[]>;
    getNetworks(): Promise<NetworkInfo[]>;
    getDataPlanTypes(): Promise<{
        value: string;
        label: string;
        description?: string;
    }[]>;
    private getPlanTypeDescription;
    payElectricityBill(params: PayBillParams & {
        meterNumber: string;
        meterType: MeterType;
        electricityProvider: ElectricityProvider;
        customerName?: string;
        customerAddress?: string;
        units?: number;
    }): Promise<{
        transaction: any;
        response: BillResponse;
    }>;
    payCableBill(params: PayBillParams & {
        smartCardNumber: string;
        cableProvider: CableProvider;
        customerName?: string;
        package?: string;
        months?: number;
    }): Promise<{
        transaction: any;
        response: BillResponse;
    }>;
    validateElectricityMeter(meterNumber: string, provider: ElectricityProvider, meterType: MeterType): Promise<ElectricityValidationResponse>;
    validateCableIUC(smartCardNumber: string, provider: CableProvider): Promise<CableValidationResponse>;
    buyExamPin(params: BuyExamPinParams): Promise<{
        transaction: any;
        response: ExamPinResponse;
    }>;
    generateRechargePins(userId: string, currency: 'NGN' | 'USD', amount: number, quantity: number, reference: string): Promise<{
        transaction: any;
        response: ExamPinResponse;
    }>;
    queryTransaction(query: TransactionQuery): Promise<any>;
    getTransactionHistory(filters?: Record<string, any>): Promise<any[]>;
    getProviderStatus(): {
        currentProvider: import("../../integrations/vtu-bills/vtu-bills.types").ProviderName;
        sandboxMode: boolean;
        availableProviders: string[];
        totalProviders: number;
    };
    getAvailableProviders(): {
        name: import("../../integrations/vtu-bills/vtu-bills.types").ProviderName;
        info: {
            name: string;
            version: string;
            features: string[];
        };
    }[];
    setProvider(providerName: string): void;
    enableSandboxMode(): void;
    disableSandboxMode(): void;
    isSandboxMode(): boolean;
    private validateVtuRequest;
    private validateBillRequest;
    private validateExamPinRequest;
    private checkWalletBalance;
    private processReversal;
}
export declare const vtuBillsService: VtuBillsService;
