"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const rate_limit_1 = require("../../config/rate-limit");
const vtu_bills_controller_1 = require("./vtu-bills.controller");
const router = (0, express_1.Router)();
router.use(rate_limit_1.paymentRateLimit);
router.get('/health', vtu_bills_controller_1.VtuBillsController.healthCheck);
router.get('/providers', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getAvailableProviders);
router.get('/provider/status', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getProviderStatus);
router.post('/provider/set', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.setProvider);
router.post('/sandbox/enable', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.enableSandboxMode);
router.post('/sandbox/disable', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.disableSandboxMode);
router.get('/sandbox/status', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getSandboxStatus);
router.post('/vtu/airtime', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.buyAirtime);
router.post('/vtu/data', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.buyData);
router.get('/vtu/networks', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getNetworks);
router.get('/vtu/data-plans/:network', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getDataPlans);
router.get('/vtu/data-plan-types', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getDataPlanTypes);
router.post('/bills/electricity', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.payElectricityBill);
router.post('/bills/cable', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.payCableBill);
router.post('/validate/electricity-meter', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.validateElectricityMeter);
router.post('/validate/cable-iuc', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.validateCableIUC);
router.post('/exam-pins/buy', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.buyExamPin);
router.post('/exam-pins/generate-recharge', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.generateRechargePins);
router.get('/transactions/query', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.queryTransaction);
router.get('/transactions/history', auth_1.requireAuth, vtu_bills_controller_1.VtuBillsController.getTransactionHistory);
exports.default = router;
