import { VerificationType, VerificationResponse, NinVerificationRequest, BvnVerificationRequest, BvnVerificationByPhoneRequest, IpeClearanceRequest, IpeClearanceStatusResponse, PersonalizationRequest, VerificationTransaction } from '../../integrations/verification/verification.types';
export declare class VerificationService {
    private static instance;
    private constructor();
    static getInstance(): VerificationService;
    verifyNin(request: NinVerificationRequest, idempotencyKey?: string): Promise<VerificationResponse>;
    verifyBvn(request: BvnVerificationRequest, idempotencyKey?: string): Promise<VerificationResponse>;
    verifyBvnByPhone(request: BvnVerificationByPhoneRequest, idempotencyKey?: string): Promise<VerificationResponse>;
    createIpeClearance(request: IpeClearanceRequest, idempotencyKey?: string): Promise<VerificationResponse>;
    getIpeClearanceStatus(transactionId: number): Promise<IpeClearanceStatusResponse>;
    createPersonalization(request: PersonalizationRequest, idempotencyKey?: string): Promise<VerificationResponse>;
    getProviderStatus(): Promise<Record<string, any>>;
    healthCheck(): Promise<boolean>;
    enableSandboxMode(): void;
    disableSandboxMode(): void;
    isSandboxMode(): boolean;
    getSandboxConfig(): any;
    updateSandboxConfig(config: any): void;
    getTransaction(idempotencyKey: string): Promise<VerificationTransaction | null>;
    getTransactionsByType(type: VerificationType, limit?: number): Promise<VerificationTransaction[]>;
    getUserTransactions(userId: string, limit?: number, offset?: number): Promise<VerificationTransaction[]>;
    private generateIdempotencyKey;
    private resolveNinSubService;
    private ensureServiceEnabled;
    private resolveProviderFor;
    private isValidFullApiKey;
    private checkIdempotency;
    private storeIdempotencyResult;
    createTransaction(data: Partial<VerificationTransaction>): Promise<VerificationTransaction>;
    private updateTransaction;
    private validateNinRequest;
    private validateBvnRequest;
    private validateBvnByPhoneRequest;
    private validateIpeClearanceRequest;
    private validatePersonalizationRequest;
    createPendingBvnByPhoneRequest(request: BvnVerificationByPhoneRequest, idempotencyKey?: string, price?: number): Promise<any>;
}
export declare const verificationService: VerificationService;
