"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const rate_limit_1 = require("../../config/rate-limit");
const verification_controller_1 = require("./verification.controller");
const ninslip_controller_1 = require("./ninslip.controller");
const ninslip_test_controller_1 = require("./ninslip-test.controller");
const router = (0, express_1.Router)();
router.get('/health', verification_controller_1.VerificationController.healthCheck);
router.get('/health/detailed', verification_controller_1.VerificationController.detailedHealthCheck);
router.get('/metrics', verification_controller_1.VerificationController.getMetrics);
router.get('/pricing', verification_controller_1.VerificationController.getPricing);
router.get('/nin/slip/:trackingId', auth_1.requireAuth, ninslip_controller_1.NinSlipController.getPremiumSlip);
router.get('/nin/slip/standard/:trackingId', auth_1.requireAuth, ninslip_controller_1.NinSlipController.getStandardSlip);
router.get('/nin/slip/regular/:trackingId', auth_1.requireAuth, ninslip_controller_1.NinSlipController.getRegularSlip);
router.get('/nin/test/premium', ninslip_test_controller_1.NinSlipTestController.getTestPremiumSlip);
router.get('/nin/test/standard', ninslip_test_controller_1.NinSlipTestController.getTestStandardSlip);
router.get('/nin/test/regular', ninslip_test_controller_1.NinSlipTestController.getTestRegularSlip);
router.get('/nin/test/data', ninslip_test_controller_1.NinSlipTestController.getTestData);
router.post('/nin/test/custom', ninslip_test_controller_1.NinSlipTestController.getCustomTestSlip);
router.get('/providers/status', auth_1.requireAuth, verification_controller_1.VerificationController.getProviderStatus);
router.post('/providers/config', auth_1.requireAuth, verification_controller_1.VerificationController.updateProviderConfig);
router.post('/sandbox/enable', auth_1.requireAuth, verification_controller_1.VerificationController.enableSandboxMode);
router.post('/sandbox/disable', auth_1.requireAuth, verification_controller_1.VerificationController.disableSandboxMode);
router.get('/sandbox/config', auth_1.requireAuth, verification_controller_1.VerificationController.getSandboxConfig);
router.put('/sandbox/config', auth_1.requireAuth, verification_controller_1.VerificationController.updateSandboxConfig);
router.post('/nin/verify', auth_1.requireAuth, rate_limit_1.verificationRateLimit, verification_controller_1.VerificationController.verifyNin);
router.post('/bvn/verify', auth_1.requireAuth, rate_limit_1.verificationRateLimit, verification_controller_1.VerificationController.verifyBvn);
router.post('/bvn/verify-by-phone', auth_1.requireAuth, rate_limit_1.verificationRateLimit, verification_controller_1.VerificationController.verifyBvnByPhone);
router.post('/ipe/clearance', auth_1.requireAuth, verification_controller_1.VerificationController.createIpeClearance);
router.get('/ipe/clearance/:transactionId/status', auth_1.requireAuth, verification_controller_1.VerificationController.getIpeClearanceStatus);
router.post('/personalization', auth_1.requireAuth, verification_controller_1.VerificationController.createPersonalization);
router.get('/transactions/:idempotencyKey', auth_1.requireAuth, verification_controller_1.VerificationController.getTransaction);
router.get('/transactions/type/:type', auth_1.requireAuth, verification_controller_1.VerificationController.getTransactionsByType);
router.get('/transactions/individual', auth_1.requireAuth, verification_controller_1.VerificationController.getIndividualTransactions);
router.post('/webhook', verification_controller_1.VerificationController.handleWebhook);
exports.default = router;
