import { Request, Response } from 'express';
import { ValidationError, IdempotencyError, ProviderError } from '../../integrations/verification/verification.types';
export declare class VerificationController {
    static getPricing: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static healthCheck: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static detailedHealthCheck: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getMetrics: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static verifyNin: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static verifyBvn: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static verifyBvnByPhone: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static createIpeClearance: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getIpeClearanceStatus: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static createPersonalization: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getProviderStatus: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static enableSandboxMode: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static disableSandboxMode: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getSandboxConfig: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static updateSandboxConfig: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static updateProviderConfig: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getTransaction: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getTransactionsByType: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static getIndividualTransactions: (req: Request, res: Response, next: import("express").NextFunction) => void;
    static handleWebhook: (req: Request, res: Response, next: import("express").NextFunction) => void;
    private static verifyWebhookSignature;
    private static processNinVerificationWebhook;
    private static processBvnVerificationWebhook;
    private static processIpeClearanceWebhook;
    private static processPersonalizationWebhook;
    static handleValidationError: (error: ValidationError, _req: Request, res: Response) => void;
    static handleIdempotencyError: (error: IdempotencyError, _req: Request, res: Response) => void;
    static handleProviderError: (error: ProviderError, _req: Request, res: Response) => void;
}
