"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerificationMonitor = void 0;
const provider_manager_1 = require("../../integrations/verification/provider-manager");
class VerificationMonitor {
    static instance;
    providerManager;
    constructor() {
        this.providerManager = provider_manager_1.VerificationProviderManager.getInstance();
    }
    static getInstance() {
        if (!VerificationMonitor.instance) {
            VerificationMonitor.instance = new VerificationMonitor();
        }
        return VerificationMonitor.instance;
    }
    async getHealthReport() {
        const services = [];
        let overallStatus = 'healthy';
        try {
            const unifyHealth = await this.checkUnifyProviderHealth();
            services.push(unifyHealth);
            const redisHealth = await this.checkRedisHealth();
            services.push(redisHealth);
            const unhealthyServices = services.filter(s => s.status === 'unhealthy');
            const degradedServices = services.filter(s => s.status === 'degraded');
            if (unhealthyServices.length > 0) {
                overallStatus = 'unhealthy';
            }
            else if (degradedServices.length > 0) {
                overallStatus = 'degraded';
            }
        }
        catch (error) {
            console.error('[VerificationMonitor] Health check failed:', error);
            overallStatus = 'unhealthy';
        }
        return {
            overall: overallStatus,
            services,
            timestamp: new Date()
        };
    }
    async checkUnifyProviderHealth() {
        try {
            const provider = this.providerManager.getCurrentProvider();
            if (provider && typeof provider.getCircuitBreakerStatus === 'function') {
                const circuitBreakerStatus = provider.getCircuitBreakerStatus();
                const isHealthy = await provider.healthCheck();
                let status = 'healthy';
                if (!isHealthy) {
                    status = 'unhealthy';
                }
                else if (circuitBreakerStatus.state === 'OPEN') {
                    status = 'degraded';
                }
                return {
                    service: 'UnifyProvider',
                    status,
                    lastCheck: new Date(),
                    details: {
                        healthCheck: isHealthy,
                        circuitBreaker: circuitBreakerStatus
                    }
                };
            }
            return {
                service: 'UnifyProvider',
                status: 'healthy',
                lastCheck: new Date(),
                details: { message: 'Provider not available for detailed check' }
            };
        }
        catch (error) {
            return {
                service: 'UnifyProvider',
                status: 'unhealthy',
                lastCheck: new Date(),
                details: { error: error instanceof Error ? error.message : String(error) }
            };
        }
    }
    async checkRedisHealth() {
        try {
            const { RedisManager } = await Promise.resolve().then(() => __importStar(require('../../config/redis')));
            const redisManager = RedisManager.getInstance();
            const client = await redisManager.getClient('main');
            if (client && typeof client.ping === 'function') {
                await client.ping();
                return {
                    service: 'Redis',
                    status: 'healthy',
                    lastCheck: new Date(),
                    details: { message: 'Redis connection active' }
                };
            }
            else {
                return {
                    service: 'Redis',
                    status: 'degraded',
                    lastCheck: new Date(),
                    details: { message: 'Using fallback storage' }
                };
            }
        }
        catch (error) {
            return {
                service: 'Redis',
                status: 'degraded',
                lastCheck: new Date(),
                details: {
                    message: 'Redis unavailable, using fallback',
                    error: error instanceof Error ? error.message : String(error)
                }
            };
        }
    }
    async getMetrics() {
        try {
            const provider = this.providerManager.getCurrentProvider();
            if (provider && typeof provider.getCircuitBreakerStatus === 'function') {
                return {
                    circuitBreaker: provider.getCircuitBreakerStatus(),
                    timestamp: new Date()
                };
            }
            return {
                message: 'Metrics not available for current provider',
                timestamp: new Date()
            };
        }
        catch (error) {
            return {
                error: error instanceof Error ? error.message : String(error),
                timestamp: new Date()
            };
        }
    }
}
exports.VerificationMonitor = VerificationMonitor;
