export interface ServiceHealth {
    service: string;
    status: 'healthy' | 'degraded' | 'unhealthy';
    lastCheck: Date;
    details: any;
}
export interface VerificationHealthReport {
    overall: 'healthy' | 'degraded' | 'unhealthy';
    services: ServiceHealth[];
    timestamp: Date;
}
export declare class VerificationMonitor {
    private static instance;
    private providerManager;
    private constructor();
    static getInstance(): VerificationMonitor;
    getHealthReport(): Promise<VerificationHealthReport>;
    private checkUnifyProviderHealth;
    private checkRedisHealth;
    getMetrics(): Promise<{
        circuitBreaker: any;
        timestamp: Date;
        message?: undefined;
        error?: undefined;
    } | {
        message: string;
        timestamp: Date;
        circuitBreaker?: undefined;
        error?: undefined;
    } | {
        error: string;
        timestamp: Date;
        circuitBreaker?: undefined;
        message?: undefined;
    }>;
}
