import { CreateUserInput, UpdateUserInput } from './user.schemas';
import { UserDocument } from './user.model';
export declare class UserService {
    private hashPassword;
    private verifyPassword;
    createUser(input: CreateUserInput): Promise<UserDocument>;
    getUserById(userId: string): Promise<UserDocument | null>;
    listUsers(params?: {
        limit?: number;
        skip?: number;
    }): Promise<UserDocument[]>;
    updateUser(userId: string, input: UpdateUserInput): Promise<UserDocument | null>;
    deleteUser(userId: string): Promise<void>;
    changePasswordSelf(userId: string, currentPassword: string, newPassword: string): Promise<void>;
    changePasswordAdmin(userId: string, newPassword: string): Promise<void>;
    changeRole(userId: string, role: 'user' | 'admin'): Promise<UserDocument | null>;
    setSuspended(userId: string, isSuspended: boolean): Promise<UserDocument | null>;
}
export declare const userService: UserService;
