"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.suspendUserSchema = exports.changeRoleSchema = exports.adminChangePasswordSchema = exports.changePasswordSchema = exports.updateUserSchema = exports.createUserSchema = void 0;
const zod_1 = require("zod");
exports.createUserSchema = zod_1.z.object({
    email: zod_1.z.string().email().optional(),
    phone: zod_1.z.string().min(7).max(20).optional(),
    password: zod_1.z.string().min(8),
    firstName: zod_1.z.string().min(1).max(100).optional(),
    lastName: zod_1.z.string().min(1).max(100).optional(),
    role: zod_1.z.enum(['user', 'admin']).optional(),
}).refine((data) => Boolean(data.email || data.phone), {
    message: 'Either email or phone is required',
    path: ['email'],
});
exports.updateUserSchema = zod_1.z.object({
    email: zod_1.z.string().email().optional(),
    phone: zod_1.z.string().min(7).max(20).optional(),
    firstName: zod_1.z.string().min(1).max(100).optional(),
    lastName: zod_1.z.string().min(1).max(100).optional(),
    avatarUrl: zod_1.z.string().url().optional(),
});
exports.changePasswordSchema = zod_1.z.object({
    currentPassword: zod_1.z.string().min(8),
    newPassword: zod_1.z.string().min(8),
});
exports.adminChangePasswordSchema = zod_1.z.object({
    newPassword: zod_1.z.string().min(8),
});
exports.changeRoleSchema = zod_1.z.object({
    role: zod_1.z.enum(['user', 'admin']),
});
exports.suspendUserSchema = zod_1.z.object({
    isSuspended: zod_1.z.boolean(),
});
