"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userRepository = exports.UserRepository = void 0;
const user_model_1 = require("./user.model");
class UserRepository {
    async findById(userId) {
        return user_model_1.User.findOne({ _id: userId, isDeleted: { $ne: true } });
    }
    async findOne(filter) {
        return user_model_1.User.findOne({ ...filter, isDeleted: { $ne: true } });
    }
    async list(filter = {}, options) {
        const { limit = 20, skip = 0 } = options || {};
        return user_model_1.User.find({ ...filter, isDeleted: { $ne: true } }).skip(skip).limit(limit).sort({ createdAt: -1 });
    }
    async create(data) {
        const user = new user_model_1.User(data);
        return user.save();
    }
    async updateById(userId, update) {
        return user_model_1.User.findByIdAndUpdate(userId, update, { new: true });
    }
    async deleteById(userId) {
        await user_model_1.User.findByIdAndUpdate(userId, { $set: { isDeleted: true, deletedAt: new Date() } });
    }
}
exports.UserRepository = UserRepository;
exports.userRepository = new UserRepository();
