import { FilterQuery, UpdateQuery } from 'mongoose';
import { UserDocument } from './user.model';
export declare class UserRepository {
    findById(userId: string): Promise<UserDocument | null>;
    findOne(filter: FilterQuery<UserDocument>): Promise<UserDocument | null>;
    list(filter?: FilterQuery<UserDocument>, options?: {
        limit?: number;
        skip?: number;
    }): Promise<UserDocument[]>;
    create(data: Partial<UserDocument>): Promise<UserDocument>;
    updateById(userId: string, update: UpdateQuery<UserDocument>): Promise<UserDocument | null>;
    deleteById(userId: string): Promise<void>;
}
export declare const userRepository: UserRepository;
