import { Document, Model } from 'mongoose';
export interface UserDocument extends Document {
    id: string;
    email?: string;
    phone?: string;
    passwordHash: string;
    role: 'user' | 'admin';
    firstName?: string;
    lastName?: string;
    isEmailVerified: boolean;
    isPhoneVerified: boolean;
    avatarUrl?: string;
    isSuspended: boolean;
    lastLoginAt?: Date;
    lastLoginIp?: string;
    transactionPinHash?: string;
    isDeleted?: boolean;
    deletedAt?: Date;
    accountNumber?: string;
    bankName?: string;
    virtualAccount?: {
        accountNumber: string;
        bankName: string;
        bankCode?: string;
        accountName?: string;
    };
    createdAt: Date;
    updatedAt: Date;
}
export declare const User: Model<UserDocument>;
