"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sessionService = exports.SessionService = void 0;
const session_model_1 = require("./session.model");
class SessionService {
    async create(userId, meta) {
        const session = new session_model_1.UserSession({ userId, ...meta, lastSeenAt: new Date() });
        return session.save();
    }
    async listForUser(userId) {
        return session_model_1.UserSession.find({ userId }).sort({ updatedAt: -1 });
    }
    async touch(sessionId) {
        await session_model_1.UserSession.findByIdAndUpdate(sessionId, { $set: { lastSeenAt: new Date() } });
    }
    async revoke(sessionId) {
        await session_model_1.UserSession.findByIdAndUpdate(sessionId, { $set: { revokedAt: new Date() } });
    }
    async revokeAllForUser(userId) {
        await session_model_1.UserSession.updateMany({ userId, revokedAt: { $exists: false } }, { $set: { revokedAt: new Date() } });
    }
}
exports.SessionService = SessionService;
exports.sessionService = new SessionService();
