"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const session_controller_1 = require("./session.controller");
const router = (0, express_1.Router)();
router.get('/', auth_1.requireAuth, (req, res) => session_controller_1.sessionController.list(req, res));
router.post('/:sessionId/revoke', auth_1.requireAuth, (req, res) => session_controller_1.sessionController.revoke(req, res));
router.post('/revoke-all', auth_1.requireAuth, (req, res) => session_controller_1.sessionController.revokeAll(req, res));
exports.default = router;
