"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sessionController = void 0;
const session_service_1 = require("./session.service");
class SessionController {
    async list(req, res) {
        const userId = req.user?.userId;
        if (!userId) {
            res.status(401).json({ error: 'Unauthorized' });
            return;
        }
        const sessions = await session_service_1.sessionService.listForUser(userId);
        res.status(200).json({ sessions: sessions.map((s) => s.toJSON()) });
    }
    async revoke(req, res) {
        const userId = req.user?.userId;
        if (!userId) {
            res.status(401).json({ error: 'Unauthorized' });
            return;
        }
        const sessionId = req.params['sessionId'];
        if (!sessionId) {
            res.status(400).json({ error: 'Session ID is required' });
            return;
        }
        await session_service_1.sessionService.revoke(sessionId);
        res.status(204).send();
    }
    async revokeAll(req, res) {
        const userId = req.user?.userId;
        if (!userId) {
            res.status(401).json({ error: 'Unauthorized' });
            return;
        }
        await session_service_1.sessionService.revokeAllForUser(userId);
        res.status(204).send();
    }
}
exports.sessionController = new SessionController();
