"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const queue_controller_1 = require("./queue.controller");
const router = (0, express_1.Router)();
router.use(auth_1.requireAuth);
router.get('/stats', queue_controller_1.queueController.getQueueStats.bind(queue_controller_1.queueController));
router.get('/stats/:queueName', queue_controller_1.queueController.getQueueStat.bind(queue_controller_1.queueController));
router.get('/scheduler/status', queue_controller_1.queueController.getJobSchedulerStatus.bind(queue_controller_1.queueController));
router.put('/scheduler/jobs/:jobId/toggle', queue_controller_1.queueController.toggleJob.bind(queue_controller_1.queueController));
router.put('/scheduler/jobs/:jobId/schedule', queue_controller_1.queueController.updateJobSchedule.bind(queue_controller_1.queueController));
router.post('/scheduler/jobs/:jobId/trigger', queue_controller_1.queueController.triggerJob.bind(queue_controller_1.queueController));
router.get('/workers/status', queue_controller_1.queueController.getWorkerManagerStatus.bind(queue_controller_1.queueController));
router.post('/workers/:queueName/pause', queue_controller_1.queueController.pauseWorker.bind(queue_controller_1.queueController));
router.post('/workers/:queueName/resume', queue_controller_1.queueController.resumeWorker.bind(queue_controller_1.queueController));
router.post('/workers/pause-all', queue_controller_1.queueController.pauseAllWorkers.bind(queue_controller_1.queueController));
router.post('/workers/resume-all', queue_controller_1.queueController.resumeAllWorkers.bind(queue_controller_1.queueController));
router.post('/:queueName/cleanup', queue_controller_1.queueController.cleanupOldJobs.bind(queue_controller_1.queueController));
router.get('/system/status', queue_controller_1.queueController.getSystemStatus.bind(queue_controller_1.queueController));
exports.default = router;
