export type PaymentProvider = 'paystack' | 'flutterwave' | 'aspfiy';
export type PaymentType = 'card' | 'bank_transfer' | 'ussd' | 'qr' | 'mobile_money';
export interface PaymentChargeRequest {
    amount: number;
    email: string;
    reference: string;
    provider: PaymentProvider;
    callbackUrl?: string;
    currency?: 'NGN' | 'USD' | 'EUR' | 'GBP';
    metadata?: Record<string, any>;
    paymentType?: PaymentType;
    customerName?: string;
    customerPhone?: string;
}
export interface PaymentChargeResponse {
    success: boolean;
    provider: PaymentProvider;
    reference: string;
    authorizationUrl: string;
    accessCode?: string;
    flwRef?: string;
    amount: number;
    currency: string;
    metadata?: Record<string, any>;
}
export interface PaymentVerificationRequest {
    reference: string;
    provider: PaymentProvider;
}
export interface PaymentVerificationResponse {
    success: boolean;
    reference: string;
    provider: PaymentProvider;
    status: string;
    amount: number;
    currency: string;
    metadata?: Record<string, any>;
    transactionId?: string;
}
export interface WebhookProcessingRequest {
    provider: PaymentProvider;
    signature: string | undefined;
    rawBody: string;
    event: any;
}
export interface ReconciliationRequest {
    provider: PaymentProvider;
    startDate: string;
    endDate: string;
}
export interface RefundRequest {
    reference: string;
    provider: PaymentProvider;
    amount?: number;
    reason?: string;
}
export declare class PaymentService {
    private static instance;
    private constructor();
    static getInstance(): PaymentService;
    initializeCharge(request: PaymentChargeRequest): Promise<PaymentChargeResponse>;
    verifyPayment(request: PaymentVerificationRequest): Promise<PaymentVerificationResponse>;
    processWebhook(request: WebhookProcessingRequest): Promise<{
        success: boolean;
        message: string;
        transactionId?: string;
    }>;
    reconcileTransactions(request: ReconciliationRequest): Promise<{
        success: boolean;
        message: string;
        reconciledCount: number;
        discrepancies: any[];
    }>;
    processRefund(request: RefundRequest): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
        message: string;
    }>;
    getPaymentStats(provider?: PaymentProvider, startDate?: string, endDate?: string): Promise<{
        totalTransactions: number;
        totalAmount: number;
        successRate: number;
        averageAmount: number;
        providerBreakdown: Record<string, any>;
    }>;
    private validateChargeRequest;
    private generateReference;
    private storePaymentIntent;
    private clearPaymentIntent;
    private updateTransactionStatus;
    private updateTransactionFromWebhook;
    private createRefundTransaction;
    private findDiscrepancies;
}
export declare const paymentService: PaymentService;
