"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const payment_controller_1 = require("./payment.controller");
const auth_1 = require("../../core/middleware/auth");
const rate_limit_1 = require("../../config/rate-limit");
const router = (0, express_1.Router)();
router.use(rate_limit_1.paymentRateLimit);
router.post('/initialize', payment_controller_1.PaymentController.initializeCharge);
router.get('/verify/:provider/:reference', payment_controller_1.PaymentController.verifyPayment);
router.get('/transaction/:reference', payment_controller_1.PaymentController.getTransaction);
router.get('/providers', payment_controller_1.PaymentController.getPaymentProviders);
router.post('/validate-bank-account', payment_controller_1.PaymentController.validateBankAccount);
router.get('/webhook-status/:reference', payment_controller_1.PaymentController.getWebhookStatus);
router.post('/aspfiy/reserved-account', payment_controller_1.PaymentController.createAspfiyReservedAccount);
router.post('/aspfiy/reserved-account-direct', payment_controller_1.PaymentController.createAspfiyReservedAccountDirect);
router.post('/aspfiy/dynamic-account', payment_controller_1.PaymentController.createAspfiyDynamicAccount);
router.get('/aspfiy/banks', payment_controller_1.PaymentController.getAspfiyBanks);
router.post('/aspfiy/resolve-account', payment_controller_1.PaymentController.resolveAspfiyAccount);
router.post('/aspfiy/transfer', payment_controller_1.PaymentController.initiateAspfiyTransfer);
router.get('/user/transactions', auth_1.requireAuth, payment_controller_1.PaymentController.getUserTransactions);
router.post('/refund/:provider/:reference', auth_1.requireAuth, payment_controller_1.PaymentController.processRefund);
router.get('/reconcile/:provider', auth_1.requireAuth, payment_controller_1.PaymentController.reconcileTransactions);
router.get('/stats', auth_1.requireAuth, payment_controller_1.PaymentController.getPaymentStats);
exports.default = router;
