import { DisputeDocument, DisputeType, DisputeStatus, DisputePriority } from '../../database/models/dispute';
export interface CreateDisputeRequest {
    userId: string;
    transactionId: string;
    type: DisputeType;
    reason: string;
    description: string;
    priority: DisputePriority;
    evidence?: string[];
    metadata?: Record<string, any>;
}
export interface UpdateDisputeRequest {
    status?: DisputeStatus;
    resolution?: string;
    resolutionAmount?: number;
    adminNotes?: string;
    metadata?: Record<string, any>;
}
export interface ChargebackRequest {
    userId: string;
    transactionId: string;
    reason: string;
    evidence: string[];
    amount?: number;
}
export declare class DisputeService {
    createDispute(request: CreateDisputeRequest): Promise<DisputeDocument>;
    updateDispute(disputeId: string, updates: UpdateDisputeRequest): Promise<DisputeDocument>;
    processChargeback(request: ChargebackRequest): Promise<DisputeDocument>;
    private processDisputeRefund;
    getDisputeById(disputeId: string): Promise<DisputeDocument | null>;
    getDisputes(filters: {
        userId?: string;
        type?: DisputeType;
        status?: DisputeStatus;
        priority?: DisputePriority;
        dateFrom?: Date;
        dateTo?: Date;
    }, page?: number, limit?: number): Promise<import("../../database/models").PaginatedResult<DisputeDocument>>;
    getDisputeStats(): Promise<any>;
    escalateUrgentDisputes(): Promise<void>;
}
export declare const disputeService: DisputeService;
