"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const dispute_controller_1 = require("./dispute.controller");
const router = (0, express_1.Router)();
router.post('/', auth_1.requireAuth, dispute_controller_1.disputeController.createDispute.bind(dispute_controller_1.disputeController));
router.post('/chargeback', auth_1.requireAuth, dispute_controller_1.disputeController.processChargeback.bind(dispute_controller_1.disputeController));
router.get('/', auth_1.requireAuth, dispute_controller_1.disputeController.getDisputes.bind(dispute_controller_1.disputeController));
router.get('/stats', auth_1.requireAuth, dispute_controller_1.disputeController.getDisputeStats.bind(dispute_controller_1.disputeController));
router.get('/:disputeId', auth_1.requireAuth, dispute_controller_1.disputeController.getDisputeById.bind(dispute_controller_1.disputeController));
router.put('/:disputeId', auth_1.requireAuth, dispute_controller_1.disputeController.updateDispute.bind(dispute_controller_1.disputeController));
router.post('/escalate', auth_1.requireAuth, dispute_controller_1.disputeController.escalateUrgentDisputes.bind(dispute_controller_1.disputeController));
exports.default = router;
