"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_1 = require("../../core/middleware/auth");
const validate_1 = require("../../core/validate");
const bills_service_1 = require("./bills.service");
const router = (0, express_1.Router)();
router.get('/electricity/discos', auth_1.requireAuth, async (_req, res) => {
    try {
        const discos = [
            { id: 'ikeja_electric', name: 'Ikeja Electric' },
            { id: 'eko_electric', name: 'Eko Electric' },
            { id: 'kano_electric', name: 'Kano Electric' },
            { id: 'jos_electric', name: 'Jos Electric' },
            { id: 'ph_electric', name: 'Port Harcourt Electric' },
            { id: 'ibadan_electric', name: 'Ibadan Electric' },
            { id: 'kaduna_electric', name: 'Kaduna Electric' },
            { id: 'abuja_electric', name: 'Abuja Electric' },
        ];
        res.status(200).json({ success: true, discos, data: discos });
    }
    catch (e) {
        res.status(500).json({ success: false, message: e?.message || 'Failed to load discos' });
    }
});
router.post('/pay', auth_1.requireAuth, (0, validate_1.validate)(validate_1.billPaySchema), async (req, res) => {
    try {
        const { amount, currency, reference, type, biller, customerId, productCode } = req.body || {};
        if (!amount || !reference || !type || !biller || !customerId) {
            res.status(400).json({ error: 'amount, reference, type, biller, customerId are required' });
            return;
        }
        const result = await bills_service_1.billsService.payBill({ userId: req.user.userId, amount, currency, reference, type, biller, customerId, productCode });
        res.status(200).json({ order: result.order });
    }
    catch (e) {
        res.status(400).json({ error: e.message || 'Failed to pay bill' });
    }
});
router.get('/exam-pins/categories', auth_1.requireAuth, async (_req, res) => {
    try {
        const categories = [
            { id: 'waec', name: 'WAEC', price: 128, description: 'West African Examinations Council' },
            { id: 'neco', name: 'NECO', price: 128, description: 'National Examinations Council' },
            { id: 'jamb', name: 'JAMB', price: 128, description: 'Joint Admissions and Matriculation Board' },
            { id: 'gce', name: 'GCE', price: 128, description: 'General Certificate of Education' },
            { id: 'nabteb', name: 'NABTEB', price: 128, description: 'National Business and Technical Examinations Board' },
        ];
        res.status(200).json({
            success: true,
            categories,
            data: categories
        });
    }
    catch (e) {
        res.status(500).json({
            success: false,
            message: e?.message || 'Failed to load exam pin categories'
        });
    }
});
router.post('/exam-pins/purchase', auth_1.requireAuth, async (req, res) => {
    try {
        const { categoryId, quantity, amount, currency = 'NGN', reference } = req.body;
        if (!categoryId || !quantity || !amount || !reference) {
            return res.status(400).json({
                success: false,
                message: 'categoryId, quantity, amount, and reference are required'
            });
        }
        const vtuBillsReference = `exam-${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
        const vtuBillsUrl = `/api/v1/vtu-bills/exam-pins/buy`;
        const vtuBillsPayload = {
            examType: categoryId,
            quantity: Number(quantity),
            amount: Number(amount),
            currency,
            reference: vtuBillsReference,
            provider: 'asbdata'
        };
        const { VtuBillsController } = await Promise.resolve().then(() => __importStar(require('../vtu-bills/vtu-bills.controller')));
        const mockReq = {
            ...req,
            body: vtuBillsPayload
        };
        let responseData = null;
        let statusCode = 200;
        const mockRes = {
            status: (code) => {
                statusCode = code;
                return mockRes;
            },
            json: (data) => {
                responseData = data;
                return mockRes;
            }
        };
        await VtuBillsController.buyExamPin(mockReq, mockRes, () => { });
        res.status(statusCode).json(responseData);
    }
    catch (e) {
        res.status(500).json({
            success: false,
            message: e?.message || 'Failed to purchase exam pin'
        });
    }
});
exports.default = router;
