export interface SignupInput {
    email?: string | undefined;
    phone?: string | undefined;
    password: string;
    firstName?: string;
    lastName?: string;
}
export interface LoginInput {
    email?: string | undefined;
    phone?: string | undefined;
    password: string;
}
export interface AuthTokens {
    accessToken: string;
    refreshToken: string;
}
export interface AuthPayload {
    userId: string;
    jti?: string;
    role?: 'user' | 'admin';
}
export interface RefreshInput {
    refreshToken: string;
}
export interface LogoutInput {
    refreshToken: string;
}
export interface VerificationRequestInput {
    channel: 'email' | 'phone';
    userId: string;
}
export interface VerificationConfirmInput {
    channel: 'email' | 'phone';
    userId: string;
    code: string;
}
export interface ForgotPasswordInput {
    email?: string;
    phone?: string;
}
export interface ResetPasswordInput {
    token: string;
    newPassword: string;
}
export interface IntrospectInput {
    token: string;
    type: 'access' | 'refresh';
}
