import { UserDocument } from '../users/user.model';
import { LoginInput, SignupInput, AuthTokens, RefreshInput } from './auth.types';
export declare class AuthService {
    private hashPassword;
    private verifyPassword;
    private blacklistRefreshToken;
    private isRefreshTokenBlacklisted;
    private generateTokens;
    signup(input: SignupInput): Promise<{
        user: UserDocument;
        tokens: AuthTokens;
    }>;
    login(input: LoginInput): Promise<{
        user: UserDocument;
        tokens: AuthTokens;
    }>;
    refresh(input: RefreshInput): Promise<AuthTokens>;
    logout(input: RefreshInput): Promise<void>;
    private storeCode;
    private getCode;
    sendVerificationCode(user: UserDocument, channel: 'email' | 'phone'): Promise<void>;
    confirmVerification(user: UserDocument, channel: 'email' | 'phone', code: string): Promise<boolean>;
    sendPasswordReset(user: UserDocument): Promise<void>;
    private generatePasswordResetEmail;
    private generatePasswordResetEmailHTML;
    resetPassword(token: string, newPassword: string): Promise<boolean>;
}
export declare const authService: AuthService;
