"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.changeRoleSchema = exports.introspectSchema = exports.resetPasswordSchema = exports.forgotPasswordSchema = exports.verificationConfirmSchema = exports.verificationRequestSchema = exports.logoutSchema = exports.refreshSchema = exports.loginSchema = exports.signupSchema = void 0;
const zod_1 = require("zod");
exports.signupSchema = zod_1.z.object({
    email: zod_1.z.string().email().optional(),
    phone: zod_1.z.string().min(7).max(20).optional(),
    password: zod_1.z.string().min(8),
    firstName: zod_1.z.string().min(1).max(100).optional(),
    lastName: zod_1.z.string().min(1).max(100).optional(),
}).refine((data) => Boolean(data.email || data.phone), {
    message: 'Either email or phone is required',
    path: ['email'],
});
exports.loginSchema = zod_1.z.object({
    email: zod_1.z.string().email().optional(),
    phone: zod_1.z.string().min(7).max(20).optional(),
    password: zod_1.z.string().min(8),
}).refine((data) => Boolean(data.email || data.phone), {
    message: 'Either email or phone is required',
    path: ['email'],
});
exports.refreshSchema = zod_1.z.object({
    refreshToken: zod_1.z.string().min(10),
});
exports.logoutSchema = zod_1.z.object({
    refreshToken: zod_1.z.string().min(10),
});
exports.verificationRequestSchema = zod_1.z.object({
    channel: zod_1.z.enum(['email', 'phone']),
    userId: zod_1.z.string().min(1),
});
exports.verificationConfirmSchema = zod_1.z.object({
    channel: zod_1.z.enum(['email', 'phone']),
    userId: zod_1.z.string().min(1),
    code: zod_1.z.string().min(4).max(8),
});
exports.forgotPasswordSchema = zod_1.z.object({
    email: zod_1.z.string().email().optional(),
    phone: zod_1.z.string().min(7).max(20).optional(),
}).refine((data) => Boolean(data.email || data.phone), {
    message: 'Either email or phone is required',
    path: ['email'],
});
exports.resetPasswordSchema = zod_1.z.object({
    token: zod_1.z.string().min(10),
    newPassword: zod_1.z.string().min(8),
});
exports.introspectSchema = zod_1.z.object({
    token: zod_1.z.string().min(10),
    type: zod_1.z.enum(['access', 'refresh']),
});
exports.changeRoleSchema = zod_1.z.object({
    userId: zod_1.z.string().min(1),
    role: zod_1.z.enum(['user', 'admin']),
});
