import { z } from 'zod';
export declare const signupSchema: z.ZodEffects<z.ZodObject<{
    email: z.ZodOptional<z.ZodString>;
    phone: z.ZodOptional<z.ZodString>;
    password: z.ZodString;
    firstName: z.ZodOptional<z.ZodString>;
    lastName: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
    firstName?: string | undefined;
    lastName?: string | undefined;
}, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
    firstName?: string | undefined;
    lastName?: string | undefined;
}>, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
    firstName?: string | undefined;
    lastName?: string | undefined;
}, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
    firstName?: string | undefined;
    lastName?: string | undefined;
}>;
export declare const loginSchema: z.ZodEffects<z.ZodObject<{
    email: z.ZodOptional<z.ZodString>;
    phone: z.ZodOptional<z.ZodString>;
    password: z.ZodString;
}, "strip", z.ZodTypeAny, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
}, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
}>, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
}, {
    password: string;
    email?: string | undefined;
    phone?: string | undefined;
}>;
export type SignupSchema = z.infer<typeof signupSchema>;
export type LoginSchema = z.infer<typeof loginSchema>;
export declare const refreshSchema: z.ZodObject<{
    refreshToken: z.ZodString;
}, "strip", z.ZodTypeAny, {
    refreshToken: string;
}, {
    refreshToken: string;
}>;
export declare const logoutSchema: z.ZodObject<{
    refreshToken: z.ZodString;
}, "strip", z.ZodTypeAny, {
    refreshToken: string;
}, {
    refreshToken: string;
}>;
export declare const verificationRequestSchema: z.ZodObject<{
    channel: z.ZodEnum<["email", "phone"]>;
    userId: z.ZodString;
}, "strip", z.ZodTypeAny, {
    channel: "email" | "phone";
    userId: string;
}, {
    channel: "email" | "phone";
    userId: string;
}>;
export declare const verificationConfirmSchema: z.ZodObject<{
    channel: z.ZodEnum<["email", "phone"]>;
    userId: z.ZodString;
    code: z.ZodString;
}, "strip", z.ZodTypeAny, {
    code: string;
    channel: "email" | "phone";
    userId: string;
}, {
    code: string;
    channel: "email" | "phone";
    userId: string;
}>;
export declare const forgotPasswordSchema: z.ZodEffects<z.ZodObject<{
    email: z.ZodOptional<z.ZodString>;
    phone: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    email?: string | undefined;
    phone?: string | undefined;
}, {
    email?: string | undefined;
    phone?: string | undefined;
}>, {
    email?: string | undefined;
    phone?: string | undefined;
}, {
    email?: string | undefined;
    phone?: string | undefined;
}>;
export declare const resetPasswordSchema: z.ZodObject<{
    token: z.ZodString;
    newPassword: z.ZodString;
}, "strip", z.ZodTypeAny, {
    token: string;
    newPassword: string;
}, {
    token: string;
    newPassword: string;
}>;
export declare const introspectSchema: z.ZodObject<{
    token: z.ZodString;
    type: z.ZodEnum<["access", "refresh"]>;
}, "strip", z.ZodTypeAny, {
    type: "access" | "refresh";
    token: string;
}, {
    type: "access" | "refresh";
    token: string;
}>;
export declare const changeRoleSchema: z.ZodObject<{
    userId: z.ZodString;
    role: z.ZodEnum<["user", "admin"]>;
}, "strip", z.ZodTypeAny, {
    userId: string;
    role: "user" | "admin";
}, {
    userId: string;
    role: "user" | "admin";
}>;
