"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_controller_1 = require("./auth.controller");
const rate_limit_1 = require("../../config/rate-limit");
const auth_1 = require("../../core/middleware/auth");
const router = (0, express_1.Router)();
router.post('/signup', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.signup(req, res));
router.post('/login', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.login(req, res));
router.post('/refresh', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.refresh(req, res));
router.post('/logout', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.logout(req, res));
router.post('/verification/request', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.requestVerification(req, res));
router.post('/verification/confirm', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.confirmVerification(req, res));
router.post('/password/forgot', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.forgotPassword(req, res));
router.post('/password/reset', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.resetPassword(req, res));
router.post('/token/introspect', rate_limit_1.authRateLimit, (req, res) => auth_controller_1.authController.introspect(req, res));
router.get('/verify', auth_1.requireAuth, async (req, res) => {
    const userId = req.user?.userId;
    if (!userId) {
        res.status(401).json({ error: 'Unauthorized' });
        return;
    }
    const user = await (await Promise.resolve().then(() => __importStar(require('../users/user.model')))).User.findById(userId);
    if (!user) {
        res.status(404).json({ error: 'User not found' });
        return;
    }
    res.status(200).json({
        success: true,
        data: { user: user.toJSON() }
    });
});
router.get('/me', auth_1.requireAuth, async (req, res) => {
    const userId = req.user?.userId;
    if (!userId) {
        res.status(401).json({ error: 'Unauthorized' });
        return;
    }
    const user = await (await Promise.resolve().then(() => __importStar(require('../users/user.model')))).User.findById(userId);
    if (!user) {
        res.status(404).json({ error: 'User not found' });
        return;
    }
    res.status(200).json({ user: user.toJSON() });
});
router.put('/profile', auth_1.requireAuth, async (req, res) => {
    try {
        const userId = req.user?.userId;
        if (!userId) {
            res.status(401).json({ error: 'Unauthorized' });
            return;
        }
        const { User } = await Promise.resolve().then(() => __importStar(require('../users/user.model')));
        const user = await User.findById(userId);
        if (!user) {
            res.status(404).json({ error: 'User not found' });
            return;
        }
        const updateData = req.body;
        const allowedFields = ['accountNumber', 'bankName', 'virtualAccount', 'firstName', 'lastName', 'phone'];
        for (const field of allowedFields) {
            if (updateData[field] !== undefined) {
                user[field] = updateData[field];
            }
        }
        await user.save();
        res.status(200).json({
            success: true,
            message: 'Profile updated successfully',
            user: user.toJSON()
        });
    }
    catch (error) {
        console.error('Profile update error:', error);
        res.status(500).json({
            success: false,
            error: 'Failed to update profile'
        });
    }
});
router.post('/role', auth_1.requireAuth, (0, auth_1.requireRole)('admin'), (req, res) => auth_controller_1.authController.changeRole(req, res));
exports.default = router;
