"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NinSlipAdminController = void 0;
const fs_1 = __importDefault(require("fs"));
const nin_slip_1 = require("../../../database/models/nin-slip");
class NinSlipAdminController {
    static async purge(req, res) {
        const { trackingId } = req.params;
        const userId = req.query['userId'] || undefined;
        const filter = { trackingId };
        if (userId)
            filter.userId = userId;
        const record = await nin_slip_1.NinSlip.findOne(filter);
        if (!record) {
            res.status(404).json({ success: false, message: 'Slip record not found' });
            return;
        }
        if (record.filePath && fs_1.default.existsSync(record.filePath)) {
            try {
                fs_1.default.unlinkSync(record.filePath);
            }
            catch { }
        }
        record.filePath = undefined;
        record.fileHash = undefined;
        await record.save();
        res.json({ success: true, message: 'Slip cache purged', trackingId });
    }
    static async rebuild(req, res) {
        const { trackingId } = req.params;
        const userId = req.query['userId'] || undefined;
        const filter = { trackingId };
        if (userId)
            filter.userId = userId;
        const record = await nin_slip_1.NinSlip.findOne(filter);
        if (!record) {
            res.status(404).json({ success: false, message: 'Slip record not found' });
            return;
        }
        if (record.filePath && fs_1.default.existsSync(record.filePath)) {
            try {
                fs_1.default.unlinkSync(record.filePath);
            }
            catch { }
        }
        record.filePath = undefined;
        record.fileHash = undefined;
        await record.save();
        res.json({ success: true, message: 'Slip cache cleared; will regenerate on next request', trackingId });
    }
}
exports.NinSlipAdminController = NinSlipAdminController;
