"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.planSyncRoutes = void 0;
const express_1 = require("express");
const plan_sync_controller_1 = require("./plan-sync.controller");
const auth_1 = require("../../core/middleware/auth");
const router = (0, express_1.Router)();
exports.planSyncRoutes = router;
router.use(auth_1.requireAuth);
router.post('/sync', plan_sync_controller_1.PlanSyncController.syncPlans);
router.get('/sync/status', plan_sync_controller_1.PlanSyncController.getSyncStatus);
router.get('/:network', plan_sync_controller_1.PlanSyncController.getPlansForReview);
router.put('/:planId', plan_sync_controller_1.PlanSyncController.updatePlan);
