"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanSyncController = void 0;
const errors_1 = require("../../core/errors");
const vtu_bills_types_1 = require("../../integrations/vtu-bills/vtu-bills.types");
const plan_sync_service_1 = require("../../services/plan-sync.service");
const service_plan_repo_1 = require("../../database/repositories/service-plan.repo");
const service_provider_repo_1 = require("../../database/repositories/service-provider.repo");
class PlanSyncController {
    static syncPlans = (0, errors_1.asyncHandler)(async (req, res) => {
        try {
            console.log('[Admin] Starting plan sync...');
            const servicePlanRepo = new service_plan_repo_1.ServicePlanRepository();
            const serviceProviderRepo = new service_provider_repo_1.ServiceProviderRepository();
            const asbDataProvider = await serviceProviderRepo.findBySlug('asbdata');
            if (!asbDataProvider) {
                throw new vtu_bills_types_1.ValidationError('ASBData provider not found. Please configure it first.');
            }
            const { ASBDataProvider } = await Promise.resolve().then(() => __importStar(require('../../integrations/vtu-bills/asbdata.provider')));
            const provider = new ASBDataProvider({
                name: 'asbdata',
                baseUrl: asbDataProvider.baseUrl,
                apiKey: asbDataProvider.apiKey,
                timeout: 30000,
                retryAttempts: 3,
                sandboxMode: false,
                enabled: true,
            });
            const planSyncService = new plan_sync_service_1.PlanSyncService(servicePlanRepo, serviceProviderRepo, provider);
            const results = await planSyncService.syncPlansFromASBData();
            res.status(200).json({
                success: true,
                message: 'Plan sync completed',
                data: {
                    synced: results.synced,
                    updated: results.updated,
                    errors: results.errors,
                    totalProcessed: results.synced + results.updated,
                },
            });
        }
        catch (error) {
            console.error('[Admin] Plan sync failed:', error);
            throw error;
        }
    });
    static getSyncStatus = (0, errors_1.asyncHandler)(async (req, res) => {
        try {
            const servicePlanRepo = new service_plan_repo_1.ServicePlanRepository();
            const totalPlans = await servicePlanRepo.count({ type: 'data' });
            const activePlans = await servicePlanRepo.count({
                type: 'data',
                status: 'active',
                isVisible: true
            });
            const lastSync = await servicePlanRepo.findOne({
                type: 'data'
            });
            const networkStats = [
                { _id: 'mtn', count: 0, active: 0 },
                { _id: 'airtel', count: 0, active: 0 },
                { _id: 'glo', count: 0, active: 0 },
                { _id: '9mobile', count: 0, active: 0 }
            ];
            res.status(200).json({
                success: true,
                message: 'Sync status retrieved',
                data: {
                    totalPlans,
                    activePlans,
                    lastSync: lastSync?.updatedAt,
                    networkStats,
                    syncHealth: {
                        status: activePlans > 0 ? 'healthy' : 'needs_sync',
                        message: activePlans > 0
                            ? `${activePlans} active plans available`
                            : 'No active plans found. Run sync to populate plans.'
                    }
                },
            });
        }
        catch (error) {
            console.error('[Admin] Failed to get sync status:', error);
            throw error;
        }
    });
    static getPlansForReview = (0, errors_1.asyncHandler)(async (req, res) => {
        const { network } = req.params;
        const { type, status, page = 1, limit = 50 } = req.query;
        if (!network) {
            throw new vtu_bills_types_1.ValidationError('Network parameter is required');
        }
        try {
            const servicePlanRepo = new service_plan_repo_1.ServicePlanRepository();
            const filters = {
                type: 'data',
                network: network,
            };
            if (type)
                filters.dataPlanType = type;
            if (status)
                filters.status = status;
            const plans = await servicePlanRepo.find(filters);
            const total = await servicePlanRepo.count(filters);
            res.status(200).json({
                success: true,
                message: 'Plans retrieved for review',
                data: {
                    plans,
                    pagination: {
                        page: Number(page),
                        limit: Number(limit),
                        total,
                        totalPages: Math.ceil(total / Number(limit)),
                        hasNext: Number(page) * Number(limit) < total,
                        hasPrev: Number(page) > 1,
                    }
                },
            });
        }
        catch (error) {
            console.error('[Admin] Failed to get plans for review:', error);
            throw error;
        }
    });
    static updatePlan = (0, errors_1.asyncHandler)(async (req, res) => {
        const { planId } = req.params;
        const { sellingPrice, dataPlanType, status, isVisible, name } = req.body;
        if (!planId) {
            throw new vtu_bills_types_1.ValidationError('Plan ID is required');
        }
        try {
            const servicePlanRepo = new service_plan_repo_1.ServicePlanRepository();
            const updateData = {};
            if (sellingPrice !== undefined)
                updateData.sellingPrice = Number(sellingPrice);
            if (dataPlanType !== undefined)
                updateData.dataPlanType = dataPlanType;
            if (status !== undefined)
                updateData.status = status;
            if (isVisible !== undefined)
                updateData.isVisible = Boolean(isVisible);
            if (name !== undefined)
                updateData.name = name;
            const updatedPlan = await servicePlanRepo.updateById(planId, updateData);
            res.status(200).json({
                success: true,
                message: 'Plan updated successfully',
                data: updatedPlan,
            });
        }
        catch (error) {
            console.error('[Admin] Failed to update plan:', error);
            throw error;
        }
    });
}
exports.PlanSyncController = PlanSyncController;
