export declare class WorkerManager {
    private static instance;
    private workers;
    private isInitialized;
    private constructor();
    static getInstance(): WorkerManager;
    initializeWorkers(): Promise<void>;
    private initializeReconciliationWorkers;
    private initializeCleanupWorkers;
    private initializeReportWorkers;
    private initializeDisputeWorkers;
    private initializeNotificationWorkers;
    private initializeDataRetentionWorkers;
    getWorkerStatus(queueName: string): {
        isActive: boolean;
        concurrency: number;
    } | null;
    getAllWorkerStatuses(): Record<string, {
        isActive: boolean;
        concurrency: number;
    }>;
    pauseWorker(queueName: string): void;
    resumeWorker(queueName: string): void;
    pauseAllWorkers(): void;
    resumeAllWorkers(): void;
    getStatus(): {
        isInitialized: boolean;
        totalWorkers: number;
        activeWorkers: number;
        pausedWorkers: number;
    };
    shutdown(): Promise<void>;
}
export declare const workerManager: WorkerManager;
export declare const initializeWorkers: () => Promise<void>;
