"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runDataRetention = void 0;
const logger_1 = require("../../config/logger");
const verification_1 = require("../../database/models/verification");
const session_model_1 = require("../../modules/users/session.model");
const runDataRetention = async (policy) => {
    try {
        const now = new Date();
        const results = {};
        if (policy.sessionsDays && policy.sessionsDays > 0) {
            const cutoff = new Date(now.getTime() - policy.sessionsDays * 24 * 60 * 60 * 1000);
            const res = await session_model_1.UserSession.deleteMany({ lastSeenAt: { $lte: cutoff } });
            results['sessionsDeleted'] = res.deletedCount ?? 0;
        }
        if (policy.verificationDays && policy.verificationDays > 0) {
            const cutoff = new Date(now.getTime() - policy.verificationDays * 24 * 60 * 60 * 1000);
            const res = await verification_1.VerificationRequest.deleteMany({ updatedAt: { $lte: cutoff }, isDeleted: { $ne: true } });
            results['verificationsDeleted'] = res.deletedCount ?? 0;
        }
        logger_1.logger.info('Data retention completed', results);
        return results;
    }
    catch (e) {
        logger_1.logger.error('Data retention failed', e);
        throw e;
    }
};
exports.runDataRetention = runDataRetention;
