export interface ReconciliationConfig {
    enabled: boolean;
    schedule: string;
    providers: string[];
    retentionDays: number;
}
export declare class ReconciliationScheduler {
    private config;
    private isRunning;
    constructor(config?: Partial<ReconciliationConfig>);
    start(): void;
    stop(): void;
    private runDailyReconciliation;
    private cleanupOldReconciliations;
    runManualReconciliation(provider: string, startDate: string, endDate: string): Promise<any>;
    getStatus(): {
        enabled: boolean;
        isRunning: boolean;
        lastRun?: Date;
        nextRun?: Date;
    };
}
export declare const reconciliationScheduler: ReconciliationScheduler;
export declare const startReconciliationScheduler: () => void;
