export interface ScheduledJob {
    name: string;
    queue: string;
    jobType: string;
    pattern: string;
    data: any;
    options?: {
        priority?: number;
        attempts?: number;
        backoff?: number;
    };
    enabled: boolean;
}
export declare class JobScheduler {
    private static instance;
    private scheduledJobs;
    private isInitialized;
    private constructor();
    static getInstance(): JobScheduler;
    private initializeScheduledJobs;
    startAllJobs(): Promise<void>;
    scheduleJob(_jobId: string, job: ScheduledJob): Promise<void>;
    toggleJob(jobId: string, enabled: boolean): Promise<void>;
    updateJobSchedule(jobId: string, newPattern: string): Promise<void>;
    private isValidCronPattern;
    getJobStatus(jobId: string): {
        enabled: boolean;
        pattern: string;
        lastRun?: Date;
        nextRun?: Date;
    } | null;
    getAllJobStatuses(): Record<string, {
        enabled: boolean;
        pattern: string;
        queue: string;
        jobType: string;
    }>;
    triggerJob(jobId: string, data?: any): Promise<void>;
    getStatus(): {
        isInitialized: boolean;
        totalJobs: number;
        enabledJobs: number;
        disabledJobs: number;
    };
    stopAllJobs(): Promise<void>;
}
export declare const jobScheduler: JobScheduler;
export declare const startJobScheduler: () => Promise<void>;
