"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.startAllSchedulers = exports.scheduleRetentionJobs = void 0;
const retention_scheduler_1 = require("./retention.scheduler");
const reconciliation_scheduler_1 = require("./reconciliation.scheduler");
const job_scheduler_1 = require("./job.scheduler");
const worker_manager_1 = require("../workers/worker.manager");
const logger_1 = require("../../config/logger");
const ONE_DAY_MS = 24 * 60 * 60 * 1000;
const scheduleDaily = (task, hourUtc = 2) => {
    const now = new Date();
    const next = new Date(now);
    next.setUTCHours(hourUtc, 0, 0, 0);
    if (next.getTime() <= now.getTime()) {
        next.setUTCDate(next.getUTCDate() + 1);
    }
    const initialDelay = next.getTime() - now.getTime();
    setTimeout(() => {
        task();
        setInterval(task, ONE_DAY_MS).unref();
    }, initialDelay).unref();
};
const scheduleRetentionJobs = () => {
    const envDays = Number(process.env['DATA_RETENTION_DAYS'] || 0);
    const sessionsDays = Number(process.env['SESSION_RETENTION_DAYS'] || envDays || 0);
    const verificationDays = Number(process.env['VERIFICATION_RETENTION_DAYS'] || envDays || 0);
    if (!sessionsDays && !verificationDays) {
        logger_1.logger.info('Data retention scheduler disabled (no retention days configured)');
        return;
    }
    logger_1.logger.info('Scheduling data retention job', { sessionsDays, verificationDays });
    scheduleDaily(() => {
        (0, retention_scheduler_1.runDataRetention)({ sessionsDays, verificationDays }).catch(err => {
            logger_1.logger.error('Retention job error', err);
        });
    }, 2);
};
exports.scheduleRetentionJobs = scheduleRetentionJobs;
const startAllSchedulers = async () => {
    try {
        const { redisManager } = await Promise.resolve().then(() => __importStar(require('../../config/redis')));
        const isUsingFallback = redisManager.isUsingFallback();
        if (isUsingFallback) {
            logger_1.logger.info('Using in-memory fallback - skipping queue workers to avoid processor errors');
            logger_1.logger.info('Scheduled jobs will be disabled in fallback mode');
            return;
        }
        (0, exports.scheduleRetentionJobs)();
        (0, reconciliation_scheduler_1.startReconciliationScheduler)();
        await (0, worker_manager_1.initializeWorkers)();
        await (0, job_scheduler_1.startJobScheduler)();
        logger_1.logger.info('All schedulers started successfully');
    }
    catch (error) {
        logger_1.logger.error('Failed to start schedulers:', error);
        throw error;
    }
};
exports.startAllSchedulers = startAllSchedulers;
