import { Job } from 'bullmq';
export interface DailyReportData {
    date?: string;
    includeTransactions?: boolean;
    includeDisputes?: boolean;
    includeReconciliation?: boolean;
}
export interface WeeklyReportData {
    weekStart?: string;
    weekEnd?: string;
    includeTransactions?: boolean;
    includeDisputes?: boolean;
    includeReconciliation?: boolean;
}
export interface MonthlyReportData {
    month?: string;
    includeTransactions?: boolean;
    includeDisputes?: boolean;
    includeReconciliation?: boolean;
}
export interface DisputeReportData {
    dateFrom?: string;
    dateTo?: string;
    includeEvidence?: boolean;
    includeResolution?: boolean;
}
export interface ReportResult {
    success: boolean;
    jobType: string;
    reportData: any;
    generatedAt: Date;
    duration: number;
    errors?: string[];
}
export declare function processDailyReport(job: Job<DailyReportData>): Promise<ReportResult>;
export declare function processWeeklyReport(job: Job<WeeklyReportData>): Promise<ReportResult>;
export declare function processMonthlyReport(job: Job<MonthlyReportData>): Promise<ReportResult>;
export declare function processDisputeReport(job: Job<DisputeReportData>): Promise<ReportResult>;
export declare function getReportProcessor(jobType: string): typeof processDailyReport | typeof processWeeklyReport | typeof processMonthlyReport | typeof processDisputeReport;
