import { Job } from 'bullmq';
export interface DailyReconciliationData {
    date?: string;
    providers?: string[];
}
export interface ProviderReconciliationData {
    provider: string;
    startDate: string;
    endDate: string;
}
export interface ReconciliationResult {
    success: boolean;
    provider: string;
    reconciledCount: number;
    discrepancies: any[];
    errors?: string[];
    duration: number;
}
export declare function processDailyReconciliation(job: Job<DailyReconciliationData>): Promise<ReconciliationResult[]>;
export declare function processProviderReconciliation(job: Job<ProviderReconciliationData>): Promise<ReconciliationResult>;
export declare function getReconciliationProcessor(jobType: string): typeof processDailyReconciliation | typeof processProviderReconciliation;
